/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph.disk;

import io.github.jbellis.jvector.annotations.VisibleForTesting;
import io.github.jbellis.jvector.disk.RandomAccessReader;
import io.github.jbellis.jvector.disk.RandomAccessWriter;
import io.github.jbellis.jvector.graph.GraphIndex;
import io.github.jbellis.jvector.graph.disk.OrdinalMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonHeader {
    private static final Logger logger = LoggerFactory.getLogger(CommonHeader.class);
    private static final int V4_MAX_LAYERS = 32;
    public final int version;
    public final int dimension;
    public final int entryNode;
    public final List<LayerInfo> layerInfo;
    public final int idUpperBound;

    CommonHeader(int version, int dimension, int entryNode, List<LayerInfo> layerInfo, int idUpperBound) {
        this.version = version;
        this.dimension = dimension;
        this.entryNode = entryNode;
        this.layerInfo = layerInfo;
        this.idUpperBound = idUpperBound;
    }

    void write(RandomAccessWriter out) throws IOException {
        logger.debug("Writing common header at position {}", (Object)out.position());
        if (this.version >= 3) {
            out.writeInt(-62111);
            out.writeInt(this.version);
        }
        out.writeInt(this.layerInfo.get((int)0).size);
        out.writeInt(this.dimension);
        out.writeInt(this.entryNode);
        out.writeInt(this.layerInfo.get((int)0).degree);
        if (this.version >= 4) {
            out.writeInt(this.idUpperBound);
            if (this.layerInfo.size() > 32) {
                String msg = String.format("Number of layers %d exceeds maximum of %d", this.layerInfo.size(), 32);
                throw new IllegalArgumentException(msg);
            }
            logger.debug("Writing {} layers", (Object)this.layerInfo.size());
            out.writeInt(this.layerInfo.size());
            for (LayerInfo info : this.layerInfo) {
                out.writeInt(info.size);
                out.writeInt(info.degree);
            }
            for (int i = this.layerInfo.size(); i < 32; ++i) {
                out.writeInt(0);
                out.writeInt(0);
            }
        } else if (this.layerInfo.size() > 1) {
            throw new IllegalArgumentException("Layer info is not supported in version " + this.version);
        }
        logger.debug("Common header finished writing at position {}", (Object)out.position());
    }

    static CommonHeader load(RandomAccessReader in) throws IOException {
        List<LayerInfo> layerInfo;
        int size;
        int version;
        logger.debug("Loading common header at position {}", (Object)in.getPosition());
        int maybeMagic = in.readInt();
        if (maybeMagic == -62111) {
            version = in.readInt();
            size = in.readInt();
        } else {
            version = 2;
            size = maybeMagic;
        }
        int dimension = in.readInt();
        int entryNode = in.readInt();
        int maxDegree = in.readInt();
        int idUpperBound = size;
        if (version < 4) {
            layerInfo = List.of(new LayerInfo(size, maxDegree));
        } else {
            int i;
            idUpperBound = in.readInt();
            int numLayers = in.readInt();
            logger.debug("{} layers", (Object)numLayers);
            layerInfo = new ArrayList<LayerInfo>();
            for (i = 0; i < numLayers; ++i) {
                LayerInfo info = new LayerInfo(in.readInt(), in.readInt());
                layerInfo.add(info);
            }
            for (i = numLayers; i < 32; ++i) {
                in.readInt();
                in.readInt();
            }
        }
        logger.debug("Common header finished reading at position {}", (Object)in.getPosition());
        return new CommonHeader(version, dimension, entryNode, layerInfo, idUpperBound);
    }

    int size() {
        int size = 4;
        if (this.version >= 3) {
            size += 2;
        }
        if (this.version >= 4) {
            size += 66;
        }
        return size * 4;
    }

    @VisibleForTesting
    public static class LayerInfo {
        public final int size;
        public final int degree;

        public LayerInfo(int size, int degree) {
            this.size = size;
            this.degree = degree;
        }

        public static List<LayerInfo> fromGraph(GraphIndex graph, OrdinalMapper mapper) {
            return IntStream.rangeClosed(0, graph.getMaxLevel()).mapToObj(i -> new LayerInfo(graph.size(i), graph.getDegree(i))).collect(Collectors.toList());
        }

        public String toString() {
            return "LayerInfo{size=" + this.size + ", degree=" + this.degree + "}";
        }

        public int hashCode() {
            return Objects.hash(this.size, this.degree);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            LayerInfo other = (LayerInfo)obj;
            return this.size == other.size && this.degree == other.degree;
        }
    }
}

