/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.quantization;

import io.github.jbellis.jvector.disk.RandomAccessReader;
import io.github.jbellis.jvector.graph.similarity.ScoreFunction;
import io.github.jbellis.jvector.quantization.CompressedVectors;
import io.github.jbellis.jvector.quantization.NVQScorer;
import io.github.jbellis.jvector.quantization.NVQuantization;
import io.github.jbellis.jvector.util.RamUsageEstimator;
import io.github.jbellis.jvector.vector.VectorSimilarityFunction;
import io.github.jbellis.jvector.vector.types.VectorFloat;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

public class NVQVectors
implements CompressedVectors {
    final NVQuantization nvq;
    final NVQScorer scorer;
    final NVQuantization.QuantizedVector[] compressedVectors;

    public NVQVectors(NVQuantization nvq, NVQuantization.QuantizedVector[] compressedVectors) {
        this.nvq = nvq;
        this.scorer = new NVQScorer(nvq);
        this.compressedVectors = compressedVectors;
    }

    @Override
    public int count() {
        return this.compressedVectors.length;
    }

    @Override
    public void write(DataOutput out, int version) throws IOException {
        this.nvq.write(out, version);
        out.writeInt(this.compressedVectors.length);
        for (NVQuantization.QuantizedVector v : this.compressedVectors) {
            v.write(out);
        }
    }

    public static NVQVectors load(RandomAccessReader in) throws IOException {
        NVQuantization nvq = NVQuantization.load(in);
        int size = in.readInt();
        if (size < 0) {
            throw new IOException("Invalid compressed vector count " + size);
        }
        NVQuantization.QuantizedVector[] compressedVectors = new NVQuantization.QuantizedVector[size];
        for (int i = 0; i < size; ++i) {
            compressedVectors[i] = NVQuantization.QuantizedVector.load(in);
        }
        return new NVQVectors(nvq, compressedVectors);
    }

    public static NVQVectors load(RandomAccessReader in, long offset) throws IOException {
        in.seek(offset);
        return NVQVectors.load(in);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NVQVectors that = (NVQVectors)o;
        if (!Objects.equals(this.nvq, that.nvq)) {
            return false;
        }
        return Arrays.deepEquals(this.compressedVectors, that.compressedVectors);
    }

    public int hashCode() {
        return Objects.hash(this.nvq, Arrays.hashCode(this.compressedVectors));
    }

    @Override
    public ScoreFunction.ApproximateScoreFunction precomputedScoreFunctionFor(VectorFloat<?> query, VectorSimilarityFunction similarityFunction) {
        return this.scoreFunctionFor(query, similarityFunction);
    }

    @Override
    public ScoreFunction.ApproximateScoreFunction scoreFunctionFor(VectorFloat<?> query, VectorSimilarityFunction similarityFunction) {
        NVQScorer.NVQScoreFunction function = this.scorer.scoreFunctionFor(query, similarityFunction);
        return node2 -> function.similarityTo(this.compressedVectors[node2]);
    }

    public NVQuantization.QuantizedVector get(int ordinal) {
        return this.compressedVectors[ordinal];
    }

    public NVQuantization getNVQuantization() {
        return this.nvq;
    }

    @Override
    public int getOriginalSize() {
        return this.nvq.originalDimension * 4;
    }

    @Override
    public int getCompressedSize() {
        return this.nvq.compressedVectorSize();
    }

    public NVQuantization getCompressor() {
        return this.nvq;
    }

    @Override
    public long ramBytesUsed() {
        int REF_BYTES = RamUsageEstimator.NUM_BYTES_OBJECT_REF;
        int OH_BYTES = RamUsageEstimator.NUM_BYTES_OBJECT_HEADER;
        int AH_BYTES = RamUsageEstimator.NUM_BYTES_ARRAY_HEADER;
        long codebooksSize = this.nvq.ramBytesUsed();
        long listSize = (long)REF_BYTES * (long)(1 + this.compressedVectors.length);
        long dataSize = (long)(OH_BYTES + AH_BYTES + this.nvq.compressedVectorSize()) * (long)this.compressedVectors.length;
        return codebooksSize + listSize + dataSize;
    }

    public String toString() {
        return "NVQVectors{NVQ=" + String.valueOf(this.nvq) + ", count=" + this.compressedVectors.length + "}";
    }
}

