/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph.similarity;

import io.github.jbellis.jvector.graph.RandomAccessVectorValues;
import io.github.jbellis.jvector.graph.similarity.ScoreFunction;
import io.github.jbellis.jvector.graph.similarity.SearchScoreProvider;
import io.github.jbellis.jvector.quantization.BQVectors;
import io.github.jbellis.jvector.quantization.PQVectors;
import io.github.jbellis.jvector.vector.VectorSimilarityFunction;
import io.github.jbellis.jvector.vector.VectorUtil;
import io.github.jbellis.jvector.vector.VectorizationProvider;
import io.github.jbellis.jvector.vector.types.VectorFloat;
import io.github.jbellis.jvector.vector.types.VectorTypeSupport;
import java.util.function.Supplier;

public interface BuildScoreProvider {
    public static final VectorTypeSupport vts = VectorizationProvider.getInstance().getVectorTypeSupport();

    public boolean isExact();

    public VectorFloat<?> approximateCentroid();

    public SearchScoreProvider searchProviderFor(VectorFloat<?> var1);

    public SearchScoreProvider searchProviderFor(int var1);

    public SearchScoreProvider diversityProviderFor(int var1);

    public static BuildScoreProvider randomAccessScoreProvider(RandomAccessVectorValues ravv, final VectorSimilarityFunction similarityFunction) {
        final Supplier<RandomAccessVectorValues> vectors = ravv.threadLocalSupplier();
        final Supplier<RandomAccessVectorValues> vectorsCopy = ravv.threadLocalSupplier();
        return new BuildScoreProvider(){

            @Override
            public boolean isExact() {
                return true;
            }

            @Override
            public VectorFloat<?> approximateCentroid() {
                RandomAccessVectorValues vv = (RandomAccessVectorValues)vectors.get();
                VectorFloat<?> centroid = vts.createFloatVector(vv.dimension());
                for (int i = 0; i < vv.size(); ++i) {
                    VectorFloat<?> v = vv.getVector(i);
                    if (v == null) continue;
                    VectorUtil.addInPlace(centroid, v);
                }
                VectorUtil.scale(centroid, 1.0f / (float)vv.size());
                return centroid;
            }

            @Override
            public SearchScoreProvider searchProviderFor(VectorFloat<?> vector) {
                RandomAccessVectorValues vc = (RandomAccessVectorValues)vectorsCopy.get();
                return SearchScoreProvider.exact(vector, similarityFunction, vc);
            }

            @Override
            public SearchScoreProvider searchProviderFor(int node1) {
                RandomAccessVectorValues randomAccessVectorValues = (RandomAccessVectorValues)vectors.get();
                VectorFloat<?> v = randomAccessVectorValues.getVector(node1);
                return this.searchProviderFor(v);
            }

            @Override
            public SearchScoreProvider diversityProviderFor(int node1) {
                RandomAccessVectorValues randomAccessVectorValues = (RandomAccessVectorValues)vectors.get();
                VectorFloat<?> v = randomAccessVectorValues.getVector(node1);
                RandomAccessVectorValues vc = (RandomAccessVectorValues)vectorsCopy.get();
                return SearchScoreProvider.exact(v, similarityFunction, vc);
            }
        };
    }

    public static BuildScoreProvider pqBuildScoreProvider(final VectorSimilarityFunction vsf, final PQVectors pqv) {
        final int dimension = pqv.getOriginalSize() / 4;
        return new BuildScoreProvider(){

            @Override
            public boolean isExact() {
                return false;
            }

            @Override
            public SearchScoreProvider diversityProviderFor(int node1) {
                VectorFloat<?> v1 = vts.createFloatVector(dimension);
                pqv.getCompressor().decode(pqv.get(node1), v1);
                ScoreFunction.ApproximateScoreFunction asf = pqv.scoreFunctionFor(v1, vsf);
                return new SearchScoreProvider(asf);
            }

            @Override
            public SearchScoreProvider searchProviderFor(int node1) {
                VectorFloat<?> decoded = vts.createFloatVector(dimension);
                pqv.getCompressor().decode(pqv.get(node1), decoded);
                return this.searchProviderFor(decoded);
            }

            @Override
            public SearchScoreProvider searchProviderFor(VectorFloat<?> vector) {
                return new SearchScoreProvider(pqv.precomputedScoreFunctionFor(vector, vsf));
            }

            @Override
            public VectorFloat<?> approximateCentroid() {
                return pqv.getCompressor().getOrComputeCentroid();
            }
        };
    }

    public static BuildScoreProvider bqBuildScoreProvider(final BQVectors bqv) {
        return new BuildScoreProvider(){

            @Override
            public boolean isExact() {
                return false;
            }

            @Override
            public VectorFloat<?> approximateCentroid() {
                return vts.createFloatVector(bqv.getCompressor().getOriginalDimension());
            }

            @Override
            public SearchScoreProvider searchProviderFor(VectorFloat<?> vector) {
                return new SearchScoreProvider(bqv.scoreFunctionFor(vector, null));
            }

            @Override
            public SearchScoreProvider searchProviderFor(int node1) {
                final long[] encoded1 = bqv.get(node1);
                return new SearchScoreProvider(new ScoreFunction(){
                    final /* synthetic */ 3 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public boolean isExact() {
                        return false;
                    }

                    @Override
                    public float similarityTo(int node2) {
                        return bqv.similarityBetween(encoded1, bqv.get(node2));
                    }
                });
            }

            @Override
            public SearchScoreProvider diversityProviderFor(int node1) {
                return this.searchProviderFor(node1);
            }
        };
    }
}

