/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph;

import io.github.jbellis.jvector.annotations.VisibleForTesting;
import io.github.jbellis.jvector.util.ArrayUtil;
import io.github.jbellis.jvector.util.Bits;
import java.util.Arrays;
import org.agrona.collections.IntHashSet;

public class NodeArray {
    public static final NodeArray EMPTY = new NodeArray(0);
    protected int size;
    float[] score;
    int[] node;

    public NodeArray(int initialSize) {
        this.node = new int[initialSize];
        this.score = new float[initialSize];
    }

    static NodeArray merge(NodeArray a1, NodeArray a2) {
        NodeArray merged = new NodeArray(a1.size() + a2.size());
        int i = 0;
        int j = 0;
        IntHashSet nodesWithLastScore = new IntHashSet();
        float lastAddedScore = Float.NaN;
        while (i < a1.size() && j < a2.size()) {
            if (a1.score()[i] < a2.score[j]) {
                if (a2.score[j] != lastAddedScore) {
                    nodesWithLastScore.clear();
                    lastAddedScore = a2.score[j];
                }
                if (nodesWithLastScore.add(a2.node[j])) {
                    merged.addInOrder(a2.node[j], a2.score[j]);
                }
                ++j;
                continue;
            }
            if (a1.score()[i] > a2.score[j]) {
                if (a1.score()[i] != lastAddedScore) {
                    nodesWithLastScore.clear();
                    lastAddedScore = a1.score()[i];
                }
                if (nodesWithLastScore.add(a1.node()[i])) {
                    merged.addInOrder(a1.node()[i], a1.score()[i]);
                }
                ++i;
                continue;
            }
            if (a1.score()[i] != lastAddedScore) {
                nodesWithLastScore.clear();
                lastAddedScore = a1.score()[i];
            }
            if (nodesWithLastScore.add(a1.node()[i])) {
                merged.addInOrder(a1.node()[i], a1.score()[i]);
            }
            if (nodesWithLastScore.add(a2.node()[j])) {
                merged.addInOrder(a2.node[j], a2.score[j]);
            }
            ++i;
            ++j;
        }
        if (i < a1.size()) {
            while (i < a1.size && a1.score()[i] == lastAddedScore) {
                if (!nodesWithLastScore.contains(a1.node()[i])) {
                    merged.addInOrder(a1.node()[i], a1.score()[i]);
                }
                ++i;
            }
            System.arraycopy(a1.node, i, merged.node, merged.size, a1.size - i);
            System.arraycopy(a1.score, i, merged.score, merged.size, a1.size - i);
            merged.size += a1.size - i;
        }
        if (j < a2.size()) {
            while (j < a2.size && a2.score[j] == lastAddedScore) {
                if (!nodesWithLastScore.contains(a2.node[j])) {
                    merged.addInOrder(a2.node[j], a2.score[j]);
                }
                ++j;
            }
            System.arraycopy(a2.node, j, merged.node, merged.size, a2.size - j);
            System.arraycopy(a2.score, j, merged.score, merged.size, a2.size - j);
            merged.size += a2.size - j;
        }
        return merged;
    }

    public void addInOrder(int newNode, float newScore) {
        if (this.size == this.node.length) {
            this.growArrays();
        }
        if (this.size > 0) {
            float previousScore = this.score[this.size - 1];
            assert (previousScore >= newScore) : "Nodes are added in the incorrect order! Comparing " + newScore + " to " + Arrays.toString(ArrayUtil.copyOfSubArray(this.score, 0, this.size));
        }
        this.node[this.size] = newNode;
        this.score[this.size] = newScore;
        ++this.size;
    }

    public int insertSorted(int newNode, float newScore) {
        int insertionPoint;
        if (this.size == this.node.length) {
            this.growArrays();
        }
        if (this.duplicateExistsNear(insertionPoint = this.descSortFindRightMostInsertionPoint(newScore), newNode, newScore)) {
            return -1;
        }
        System.arraycopy(this.node, insertionPoint, this.node, insertionPoint + 1, this.size - insertionPoint);
        System.arraycopy(this.score, insertionPoint, this.score, insertionPoint + 1, this.size - insertionPoint);
        this.node[insertionPoint] = newNode;
        this.score[insertionPoint] = newScore;
        ++this.size;
        return insertionPoint;
    }

    private boolean duplicateExistsNear(int insertionPoint, int newNode, float newScore) {
        int i;
        for (i = insertionPoint - 1; i >= 0 && this.score[i] == newScore; --i) {
            if (this.node[i] != newNode) continue;
            return true;
        }
        for (i = insertionPoint; i < this.size && this.score[i] == newScore; ++i) {
            if (this.node[i] != newNode) continue;
            return true;
        }
        return false;
    }

    public void retain(Bits selected) {
        int writeIdx = 0;
        for (int readIdx = 0; readIdx < this.size; ++readIdx) {
            if (!selected.get(readIdx)) continue;
            if (writeIdx != readIdx) {
                this.node[writeIdx] = this.node[readIdx];
                this.score[writeIdx] = this.score[readIdx];
            }
            ++writeIdx;
        }
        this.size = writeIdx;
    }

    public NodeArray copy() {
        NodeArray copy = new NodeArray(this.node.length);
        copy.size = this.size;
        System.arraycopy(this.node, 0, copy.node, 0, this.size);
        System.arraycopy(this.score, 0, copy.score, 0, this.size);
        return copy;
    }

    protected final void growArrays() {
        this.node = ArrayUtil.grow(this.node);
        this.score = ArrayUtil.growExact(this.score, this.node.length);
    }

    public int size() {
        return this.size;
    }

    public int[] node() {
        return this.node;
    }

    public float[] score() {
        return this.score;
    }

    public void clear() {
        this.size = 0;
    }

    public void removeLast() {
        --this.size;
    }

    public void removeIndex(int idx) {
        System.arraycopy(this.node, idx + 1, this.node, idx, this.size - idx - 1);
        System.arraycopy(this.score, idx + 1, this.score, idx, this.size - idx - 1);
        --this.size;
    }

    public String toString() {
        return "NodeArray[" + this.size + "]";
    }

    protected final int descSortFindRightMostInsertionPoint(float newScore) {
        int start = 0;
        int end = this.size - 1;
        while (start <= end) {
            int mid = (start + end) / 2;
            if (this.score[mid] < newScore) {
                end = mid - 1;
                continue;
            }
            start = mid + 1;
        }
        return start;
    }

    @VisibleForTesting
    boolean contains(int node) {
        for (int i = 0; i < this.size; ++i) {
            if (this.node[i] != node) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    int[] copyDenseNodes() {
        return Arrays.copyOf(this.node, this.size);
    }
}

