/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.disk;

import io.github.jbellis.jvector.disk.ByteBufferReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.logging.Logger;
import sun.misc.Unsafe;

public class SimpleMappedReader
extends ByteBufferReader {
    private static final Logger LOG = Logger.getLogger(SimpleMappedReader.class.getName());
    private static final Unsafe unsafe = SimpleMappedReader.getUnsafe();

    private static Unsafe getUnsafe() {
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            return (Unsafe)f.get(null);
        }
        catch (Exception e) {
            LOG.warning("MappedRandomAccessReader can't acquire needed Unsafe access");
            return null;
        }
    }

    public SimpleMappedReader(Path path) throws IOException {
        this(path.toString());
    }

    public SimpleMappedReader(String name) throws IOException {
        this(SimpleMappedReader.getMappedByteBuffer(name));
    }

    private SimpleMappedReader(MappedByteBuffer mbb) {
        super(mbb);
    }

    private static MappedByteBuffer getMappedByteBuffer(String name) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(name, "r");
        if (raf.length() > Integer.MAX_VALUE) {
            throw new RuntimeException("MappedRandomAccessReader doesn't support large files");
        }
        MappedByteBuffer mbb = raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, raf.length());
        mbb.load();
        raf.close();
        return mbb;
    }

    @Override
    public void close() {
        if (unsafe != null) {
            try {
                unsafe.invokeCleaner(this.bb);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public SimpleMappedReader duplicate() {
        return new SimpleMappedReader((MappedByteBuffer)this.bb.duplicate());
    }
}

