/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.disk;

import io.github.jbellis.jvector.disk.MemorySegmentReader;
import io.github.jbellis.jvector.disk.RandomAccessReader;
import io.github.jbellis.jvector.disk.ReaderSupplier;
import java.io.IOException;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.nio.file.Path;

public class MemorySegmentReaderSupplier
implements ReaderSupplier {
    private final InternalMemorySegmentReader reader;

    public MemorySegmentReaderSupplier(Path path) throws IOException {
        this.reader = new InternalMemorySegmentReader(path);
    }

    @Override
    public RandomAccessReader get() {
        return this.reader.duplicate();
    }

    @Override
    public void close() {
        this.reader.close();
    }

    private static class InternalMemorySegmentReader
    extends MemorySegmentReader {
        private final boolean shouldClose;

        private InternalMemorySegmentReader(Path path) throws IOException {
            super(path);
            this.shouldClose = true;
        }

        private InternalMemorySegmentReader(Arena arena, MemorySegment memory) {
            super(arena, memory);
            this.shouldClose = false;
        }

        @Override
        public void close() {
            if (this.shouldClose) {
                super.close();
            }
        }

        @Override
        public InternalMemorySegmentReader duplicate() {
            return new InternalMemorySegmentReader(this.arena, this.memory);
        }
    }
}

