/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.vector;

import io.github.jbellis.jvector.vector.VectorUtil;
import io.github.jbellis.jvector.vector.types.VectorFloat;

public enum VectorSimilarityFunction {
    EUCLIDEAN{

        @Override
        public float compare(VectorFloat<?> v1, VectorFloat<?> v2) {
            return 1.0f / (1.0f + VectorUtil.squareL2Distance(v1, v2));
        }

        @Override
        public void compareMulti(VectorFloat<?> v1, VectorFloat<?> packedVectors, VectorFloat<?> results) {
            VectorUtil.euclideanMultiScore(v1, packedVectors, results);
        }
    }
    ,
    DOT_PRODUCT{

        @Override
        public float compare(VectorFloat<?> v1, VectorFloat<?> v2) {
            return (1.0f + VectorUtil.dotProduct(v1, v2)) / 2.0f;
        }

        @Override
        public void compareMulti(VectorFloat<?> v1, VectorFloat<?> packedVectors, VectorFloat<?> results) {
            VectorUtil.dotProductMultiScore(v1, packedVectors, results);
        }
    }
    ,
    COSINE{

        @Override
        public float compare(VectorFloat<?> v1, VectorFloat<?> v2) {
            return (1.0f + VectorUtil.cosine(v1, v2)) / 2.0f;
        }

        @Override
        public void compareMulti(VectorFloat<?> v1, VectorFloat<?> packedVectors, VectorFloat<?> results) {
            VectorUtil.cosineMultiScore(v1, packedVectors, results);
        }
    };


    public abstract float compare(VectorFloat<?> var1, VectorFloat<?> var2);

    public abstract void compareMulti(VectorFloat<?> var1, VectorFloat<?> var2, VectorFloat<?> var3);
}

