/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph.disk;

import io.github.jbellis.jvector.disk.RandomAccessReader;
import io.github.jbellis.jvector.graph.RandomAccessVectorValues;
import io.github.jbellis.jvector.graph.disk.FeatureId;
import io.github.jbellis.jvector.graph.disk.FeatureSource;
import io.github.jbellis.jvector.graph.disk.OnDiskGraphIndexWriter;
import io.github.jbellis.jvector.util.ExceptionUtils;
import io.github.jbellis.jvector.util.ExplicitThreadLocal;
import io.github.jbellis.jvector.vector.VectorizationProvider;
import io.github.jbellis.jvector.vector.types.VectorFloat;
import io.github.jbellis.jvector.vector.types.VectorTypeSupport;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;

public class InlineVectorValues
implements RandomAccessVectorValues,
Closeable {
    private static final VectorTypeSupport vts = VectorizationProvider.getInstance().getVectorTypeSupport();
    private final int dimension;
    private final OnDiskGraphIndexWriter writer;
    private final ExplicitThreadLocal<FeatureSource> sources;

    public InlineVectorValues(int dimension, OnDiskGraphIndexWriter writer) {
        this.dimension = dimension;
        this.writer = writer;
        this.sources = ExplicitThreadLocal.withInitial(writer::getFeatureSource);
    }

    @Override
    public int size() {
        return this.writer.getMaxOrdinal();
    }

    @Override
    public int dimension() {
        return this.dimension;
    }

    @Override
    public VectorFloat<?> getVector(int ordinal) {
        float[] v = new float[this.dimension];
        try {
            RandomAccessReader reader = this.sources.get().inlineReaderForNode(ordinal, FeatureId.INLINE_VECTORS);
            reader.readFully(v);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return vts.createFloatVector(v);
    }

    @Override
    public boolean isValueShared() {
        return false;
    }

    @Override
    public RandomAccessVectorValues copy() {
        return this;
    }

    @Override
    public void close() throws IOException {
        try {
            this.sources.close();
        }
        catch (Exception e) {
            ExceptionUtils.throwIoException(e);
        }
    }
}

