/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph;

import io.github.jbellis.jvector.util.AbstractLongHeap;
import io.github.jbellis.jvector.util.BoundedLongHeap;
import io.github.jbellis.jvector.util.NumericUtils;
import org.apache.commons.math3.stat.StatUtils;

interface ScoreTracker {
    public static final ScoreTracker NO_OP = new NoOpTracker();

    public void track(float var1);

    public boolean shouldStop();

    public static class NoOpTracker
    implements ScoreTracker {
        @Override
        public void track(float score) {
        }

        @Override
        public boolean shouldStop() {
            return false;
        }
    }

    public static class TwoPhaseTracker
    implements ScoreTracker {
        static final int RECENT_SCORES_TRACKED = 500;
        static final int BEST_SCORES_TRACKED = 100;
        private final double[] recentScores = new double[500];
        private int recentEntryIndex;
        AbstractLongHeap bestScores = new BoundedLongHeap(100);
        private int observationCount;
        private final double threshold;

        TwoPhaseTracker(double threshold) {
            this.threshold = threshold;
        }

        @Override
        public void track(float score) {
            this.bestScores.push(NumericUtils.floatToSortableInt(score));
            this.recentScores[this.recentEntryIndex] = score;
            this.recentEntryIndex = (this.recentEntryIndex + 1) % this.recentScores.length;
            ++this.observationCount;
        }

        @Override
        public boolean shouldStop() {
            double worstBest;
            if (this.observationCount < 500) {
                return false;
            }
            if (this.observationCount % 100 != 0) {
                return false;
            }
            double windowMedian = StatUtils.percentile((double[])this.recentScores, (double)99.0);
            return windowMedian < (worstBest = (double)NumericUtils.sortableIntToFloat((int)this.bestScores.top())) && windowMedian < this.threshold;
        }
    }
}

