/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.vector;

import io.github.jbellis.jvector.pq.LocallyAdaptiveVectorQuantization;
import io.github.jbellis.jvector.vector.VectorSimilarityFunction;
import io.github.jbellis.jvector.vector.types.ByteSequence;
import io.github.jbellis.jvector.vector.types.VectorFloat;
import java.util.List;

public interface VectorUtilSupport {
    public float dotProduct(VectorFloat<?> var1, VectorFloat<?> var2);

    public float dotProduct(VectorFloat<?> var1, int var2, VectorFloat<?> var3, int var4, int var5);

    public float cosine(VectorFloat<?> var1, VectorFloat<?> var2);

    public float cosine(VectorFloat<?> var1, int var2, VectorFloat<?> var3, int var4, int var5);

    public float squareDistance(VectorFloat<?> var1, VectorFloat<?> var2);

    public float squareDistance(VectorFloat<?> var1, int var2, VectorFloat<?> var3, int var4, int var5);

    public VectorFloat<?> sum(List<VectorFloat<?>> var1);

    public float sum(VectorFloat<?> var1);

    public void scale(VectorFloat<?> var1, float var2);

    public void addInPlace(VectorFloat<?> var1, VectorFloat<?> var2);

    public void subInPlace(VectorFloat<?> var1, VectorFloat<?> var2);

    public VectorFloat<?> sub(VectorFloat<?> var1, VectorFloat<?> var2);

    public VectorFloat<?> sub(VectorFloat<?> var1, int var2, VectorFloat<?> var3, int var4, int var5);

    public float assembleAndSum(VectorFloat<?> var1, int var2, ByteSequence<?> var3);

    public int hammingDistance(long[] var1, long[] var2);

    public void bulkShuffleSimilarity(ByteSequence<?> var1, int var2, VectorFloat<?> var3, VectorSimilarityFunction var4, VectorFloat<?> var5);

    public void calculatePartialSums(VectorFloat<?> var1, int var2, int var3, int var4, VectorFloat<?> var5, int var6, VectorSimilarityFunction var7, VectorFloat<?> var8);

    public float max(VectorFloat<?> var1);

    public float min(VectorFloat<?> var1);

    default public void dotProductMultiScore(VectorFloat<?> v1, VectorFloat<?> v2, VectorFloat<?> results) {
        for (int i = 0; i < results.length(); ++i) {
            results.set(i, (1.0f + this.dotProduct(v1, 0, v2, i * v1.length(), v1.length())) / 2.0f);
        }
    }

    default public void squareL2DistanceMultiScore(VectorFloat<?> v1, VectorFloat<?> v2, VectorFloat<?> results) {
        for (int i = 0; i < results.length(); ++i) {
            results.set(i, 1.0f / (1.0f + this.squareDistance(v1, 0, v2, i * v1.length(), v1.length())));
        }
    }

    default public void cosineMultiScore(VectorFloat<?> v1, VectorFloat<?> v2, VectorFloat<?> results) {
        for (int i = 0; i < results.length(); ++i) {
            results.set(i, (1.0f + this.cosine(v1, 0, v2, i * v1.length(), v1.length())) / 2.0f);
        }
    }

    public float lvqDotProduct(VectorFloat<?> var1, LocallyAdaptiveVectorQuantization.PackedVector var2, float var3);

    public float lvqSquareL2Distance(VectorFloat<?> var1, LocallyAdaptiveVectorQuantization.PackedVector var2);

    public float lvqCosine(VectorFloat<?> var1, LocallyAdaptiveVectorQuantization.PackedVector var2, VectorFloat<?> var3);
}

