/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph.disk;

import io.github.jbellis.jvector.disk.BufferedRandomAccessWriter;
import io.github.jbellis.jvector.graph.GraphIndex;
import io.github.jbellis.jvector.graph.NodesIterator;
import io.github.jbellis.jvector.graph.OnHeapGraphIndex;
import io.github.jbellis.jvector.graph.disk.CommonHeader;
import io.github.jbellis.jvector.graph.disk.Feature;
import io.github.jbellis.jvector.graph.disk.FeatureId;
import io.github.jbellis.jvector.graph.disk.Header;
import io.github.jbellis.jvector.graph.disk.InlineVectors;
import io.github.jbellis.jvector.graph.disk.LVQ;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.IntFunction;
import org.agrona.collections.Int2IntHashMap;

public class OnDiskGraphIndexWriter
implements Closeable {
    private final GraphIndex graph;
    private final GraphIndex.View view;
    private final Map<Integer, Integer> oldToNewOrdinals;
    private final int dimension;
    private final EnumMap<FeatureId, Feature> featureMap;
    private final BufferedRandomAccessWriter out;
    private final long startOffset;

    private OnDiskGraphIndexWriter(BufferedRandomAccessWriter out, GraphIndex graph, Map<Integer, Integer> oldToNewOrdinals, int dimension, EnumMap<FeatureId, Feature> features) throws IOException {
        this.graph = graph;
        this.view = graph.getView();
        this.oldToNewOrdinals = oldToNewOrdinals;
        this.dimension = dimension;
        this.featureMap = features;
        this.out = out;
        this.startOffset = out.getFilePointer();
    }

    @Override
    public void close() throws IOException {
        this.view.close();
        this.out.flush();
    }

    public void writeInline(BufferedRandomAccessWriter raf, int ordinal, EnumMap<FeatureId, Feature.State> stateMap) throws IOException {
        Collection<Feature> features = this.featureMap.values();
        int headerBytes = 8 + CommonHeader.size() + features.stream().mapToInt(Feature::headerSize).sum();
        int edgeSize = 4 * (1 + this.graph.maxDegree());
        int inlineBytes = ordinal * (4 + features.stream().mapToInt(Feature::inlineSize).sum() + edgeSize);
        raf.seek(this.startOffset + (long)headerBytes + (long)inlineBytes + 4L);
        for (Feature writer : features) {
            Feature.State state = stateMap.get((Object)writer.id());
            if (state == null) {
                raf.seek(raf.getFilePointer() + (long)writer.inlineSize());
                continue;
            }
            writer.writeInline(this.out, state);
        }
    }

    public void write(EnumMap<FeatureId, IntFunction<Feature.State>> featureStateSuppliers) throws IOException {
        Object ohgi;
        if (this.graph instanceof OnHeapGraphIndex && ((OnHeapGraphIndex)(ohgi = (OnHeapGraphIndex)this.graph)).getDeletedNodes().cardinality() > 0) {
            throw new IllegalArgumentException("Run builder.cleanup() before writing the graph");
        }
        if (this.oldToNewOrdinals.size() != this.graph.size()) {
            throw new IllegalArgumentException(String.format("ordinalMapper size %d does not match graph size %d", this.oldToNewOrdinals.size(), this.graph.size()));
        }
        for (Map.Entry entry : featureStateSuppliers.entrySet()) {
            if (this.featureMap.containsKey(entry.getKey())) continue;
            throw new IllegalArgumentException("Feature supplier provided for feature not in the graph");
        }
        ArrayList<Map.Entry<Integer, Integer>> entriesByNewOrdinal = new ArrayList<Map.Entry<Integer, Integer>>(this.oldToNewOrdinals.entrySet());
        entriesByNewOrdinal.sort(Comparator.comparingInt(Map.Entry::getValue));
        if (this.graph.size() > 0 && entriesByNewOrdinal.get(entriesByNewOrdinal.size() - 1).getValue() != this.graph.size() - 1) {
            throw new IllegalArgumentException("oldToNewOrdinals produced out-of-range entries");
        }
        this.out.seek(this.startOffset);
        CommonHeader commonHeader = new CommonHeader(1, this.graph.size(), this.dimension, this.view.entryNode(), this.graph.maxDegree());
        Header header = new Header(commonHeader, this.featureMap);
        header.write(this.out);
        for (int i = 0; i < this.oldToNewOrdinals.size(); ++i) {
            int n;
            Map.Entry<Integer, Integer> entry = entriesByNewOrdinal.get(i);
            int originalOrdinal = entry.getKey();
            int newOrdinal = entry.getValue();
            if (!this.graph.containsNode(originalOrdinal)) continue;
            this.out.writeInt(newOrdinal);
            for (Feature feature : this.featureMap.values()) {
                IntFunction<Feature.State> supplier = featureStateSuppliers.get((Object)feature.id());
                if (supplier == null) {
                    this.out.seek(this.out.getFilePointer() + (long)feature.inlineSize());
                    continue;
                }
                feature.writeInline(this.out, supplier.apply(originalOrdinal));
            }
            NodesIterator neighbors = this.view.getNeighborsIterator(originalOrdinal);
            this.out.writeInt(neighbors.size());
            for (n = 0; n < neighbors.size(); ++n) {
                this.out.writeInt(this.oldToNewOrdinals.get(neighbors.nextInt()));
            }
            assert (!neighbors.hasNext());
            while (n < this.graph.maxDegree()) {
                this.out.writeInt(-1);
                ++n;
            }
        }
    }

    public static Map<Integer, Integer> sequentialRenumbering(GraphIndex graph) {
        Int2IntHashMap int2IntHashMap;
        block9: {
            GraphIndex.View view = graph.getView();
            try {
                Int2IntHashMap oldToNewMap = new Int2IntHashMap(-1);
                int nextOrdinal = 0;
                for (int i = 0; i < view.getIdUpperBound(); ++i) {
                    if (!graph.containsNode(i)) continue;
                    oldToNewMap.put(i, nextOrdinal++);
                }
                int2IntHashMap = oldToNewMap;
                if (view == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (view != null) {
                        try {
                            view.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            view.close();
        }
        return int2IntHashMap;
    }

    public long checksum() throws IOException {
        long endOffset = this.out.getFilePointer();
        return this.out.checksum(this.startOffset, endOffset);
    }

    public static class Builder {
        private final GraphIndex graphIndex;
        private final Map<Integer, Integer> oldToNewOrdinals;
        private final EnumMap<FeatureId, Feature> features;
        private final BufferedRandomAccessWriter out;

        public Builder(GraphIndex graphIndex, BufferedRandomAccessWriter out) {
            this(graphIndex, out, OnDiskGraphIndexWriter.sequentialRenumbering(graphIndex));
        }

        public Builder(GraphIndex graphIndex, BufferedRandomAccessWriter out, Map<Integer, Integer> oldToNewOrdinals) {
            this.graphIndex = graphIndex;
            this.oldToNewOrdinals = oldToNewOrdinals;
            this.out = out;
            this.features = new EnumMap(FeatureId.class);
        }

        public Builder with(Feature feature) {
            this.features.put(feature.id(), feature);
            return this;
        }

        public OnDiskGraphIndexWriter build() throws IOException {
            int dimension;
            if (this.features.containsKey((Object)FeatureId.FUSED_ADC) && !this.features.containsKey((Object)FeatureId.LVQ) && !this.features.containsKey((Object)FeatureId.INLINE_VECTORS)) {
                throw new IllegalArgumentException("Fused ADC requires an exact score source.");
            }
            if (this.features.containsKey((Object)FeatureId.INLINE_VECTORS)) {
                dimension = ((InlineVectors)this.features.get((Object)FeatureId.INLINE_VECTORS)).dimension();
            } else if (this.features.containsKey((Object)FeatureId.LVQ)) {
                dimension = ((LVQ)this.features.get((Object)FeatureId.LVQ)).dimension();
            } else {
                throw new IllegalArgumentException("Either LVQ or inline vectors must be provided.");
            }
            return new OnDiskGraphIndexWriter(this.out, this.graphIndex, this.oldToNewOrdinals, dimension, this.features);
        }
    }
}

