/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.vector.cnative;

import java.lang.foreign.AddressLayout;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.GroupLayout;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.PaddingLayout;
import java.lang.foreign.SequenceLayout;
import java.lang.foreign.StructLayout;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

public class NativeSimdOps {
    static final Arena LIBRARY_ARENA = Arena.ofAuto();
    static final boolean TRACE_DOWNCALLS = Boolean.getBoolean("jextract.trace.downcalls");
    static final SymbolLookup SYMBOL_LOOKUP = SymbolLookup.loaderLookup().or(Linker.nativeLinker().defaultLookup());
    public static final ValueLayout.OfBoolean C_BOOL = ValueLayout.JAVA_BOOLEAN;
    public static final ValueLayout.OfByte C_CHAR = ValueLayout.JAVA_BYTE;
    public static final ValueLayout.OfShort C_SHORT = ValueLayout.JAVA_SHORT;
    public static final ValueLayout.OfInt C_INT = ValueLayout.JAVA_INT;
    public static final ValueLayout.OfLong C_LONG_LONG = ValueLayout.JAVA_LONG;
    public static final ValueLayout.OfFloat C_FLOAT = ValueLayout.JAVA_FLOAT;
    public static final ValueLayout.OfDouble C_DOUBLE = ValueLayout.JAVA_DOUBLE;
    public static final AddressLayout C_POINTER = ValueLayout.ADDRESS.withTargetLayout(MemoryLayout.sequenceLayout(Long.MAX_VALUE, ValueLayout.JAVA_BYTE));
    public static final ValueLayout.OfLong C_LONG = ValueLayout.JAVA_LONG;
    private static final int true_ = 1;
    private static final int false_ = 0;
    private static final int __bool_true_false_are_defined = 1;

    NativeSimdOps() {
    }

    static void traceDowncall(String name, Object ... args) {
        String traceArgs = Arrays.stream(args).map(Object::toString).collect(Collectors.joining(", "));
        System.out.printf("%s(%s)\n", name, traceArgs);
    }

    static MemorySegment findOrThrow(String symbol) {
        return SYMBOL_LOOKUP.find(symbol).orElseThrow(() -> new UnsatisfiedLinkError("unresolved symbol: " + symbol));
    }

    static MethodHandle upcallHandle(Class<?> fi, String name, FunctionDescriptor fdesc) {
        try {
            return MethodHandles.lookup().findVirtual(fi, name, fdesc.toMethodType());
        }
        catch (ReflectiveOperationException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    static MemoryLayout align(MemoryLayout layout, long align) {
        MemoryLayout memoryLayout = layout;
        Objects.requireNonNull(memoryLayout);
        MemoryLayout memoryLayout2 = memoryLayout;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PaddingLayout.class, ValueLayout.class, GroupLayout.class, SequenceLayout.class}, (Object)memoryLayout2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                PaddingLayout p;
                yield p = (PaddingLayout)memoryLayout2;
            }
            case 1 -> {
                ValueLayout v = (ValueLayout)memoryLayout2;
                yield v.withByteAlignment(align);
            }
            case 2 -> {
                GroupLayout g = (GroupLayout)memoryLayout2;
                MemoryLayout[] alignedMembers = (MemoryLayout[])g.memberLayouts().stream().map(m -> NativeSimdOps.align(m, align)).toArray(MemoryLayout[]::new);
                if (g instanceof StructLayout) {
                    yield MemoryLayout.structLayout(alignedMembers);
                }
                yield MemoryLayout.unionLayout(alignedMembers);
            }
            case 3 -> {
                SequenceLayout s = (SequenceLayout)memoryLayout2;
                yield MemoryLayout.sequenceLayout(s.elementCount(), NativeSimdOps.align(s.elementLayout(), align));
            }
        };
    }

    public static int true_() {
        return 1;
    }

    public static int false_() {
        return 0;
    }

    public static int __bool_true_false_are_defined() {
        return 1;
    }

    public static FunctionDescriptor check_compatibility$descriptor() {
        return check_compatibility.DESC;
    }

    public static MethodHandle check_compatibility$handle() {
        return check_compatibility.HANDLE;
    }

    public static boolean check_compatibility() {
        MethodHandle mh$ = check_compatibility.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                NativeSimdOps.traceDowncall("check_compatibility", new Object[0]);
            }
            return mh$.invokeExact();
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor dot_product_f32$descriptor() {
        return dot_product_f32.DESC;
    }

    public static MethodHandle dot_product_f32$handle() {
        return dot_product_f32.HANDLE;
    }

    public static float dot_product_f32(int preferred_size, MemorySegment a, int aoffset, MemorySegment b, int boffset, int length) {
        MethodHandle mh$ = dot_product_f32.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                NativeSimdOps.traceDowncall("dot_product_f32", preferred_size, a, aoffset, b, boffset, length);
            }
            return mh$.invokeExact(preferred_size, a, aoffset, b, boffset, length);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor euclidean_f32$descriptor() {
        return euclidean_f32.DESC;
    }

    public static MethodHandle euclidean_f32$handle() {
        return euclidean_f32.HANDLE;
    }

    public static float euclidean_f32(int preferred_size, MemorySegment a, int aoffset, MemorySegment b, int boffset, int length) {
        MethodHandle mh$ = euclidean_f32.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                NativeSimdOps.traceDowncall("euclidean_f32", preferred_size, a, aoffset, b, boffset, length);
            }
            return mh$.invokeExact(preferred_size, a, aoffset, b, boffset, length);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor bulk_shuffle_dot_f32_512$descriptor() {
        return bulk_shuffle_dot_f32_512.DESC;
    }

    public static MethodHandle bulk_shuffle_dot_f32_512$handle() {
        return bulk_shuffle_dot_f32_512.HANDLE;
    }

    public static void bulk_shuffle_dot_f32_512(MemorySegment shuffles, int codebookCount, MemorySegment partials, MemorySegment results) {
        MethodHandle mh$ = bulk_shuffle_dot_f32_512.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                NativeSimdOps.traceDowncall("bulk_shuffle_dot_f32_512", shuffles, codebookCount, partials, results);
            }
            mh$.invokeExact(shuffles, codebookCount, partials, results);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor bulk_shuffle_euclidean_f32_512$descriptor() {
        return bulk_shuffle_euclidean_f32_512.DESC;
    }

    public static MethodHandle bulk_shuffle_euclidean_f32_512$handle() {
        return bulk_shuffle_euclidean_f32_512.HANDLE;
    }

    public static void bulk_shuffle_euclidean_f32_512(MemorySegment shuffles, int codebookCount, MemorySegment partials, MemorySegment results) {
        MethodHandle mh$ = bulk_shuffle_euclidean_f32_512.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                NativeSimdOps.traceDowncall("bulk_shuffle_euclidean_f32_512", shuffles, codebookCount, partials, results);
            }
            mh$.invokeExact(shuffles, codebookCount, partials, results);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor assemble_and_sum_f32_512$descriptor() {
        return assemble_and_sum_f32_512.DESC;
    }

    public static MethodHandle assemble_and_sum_f32_512$handle() {
        return assemble_and_sum_f32_512.HANDLE;
    }

    public static float assemble_and_sum_f32_512(MemorySegment data, int dataBase, MemorySegment baseOffsets, int baseOffsetsLength) {
        MethodHandle mh$ = assemble_and_sum_f32_512.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                NativeSimdOps.traceDowncall("assemble_and_sum_f32_512", data, dataBase, baseOffsets, baseOffsetsLength);
            }
            return mh$.invokeExact(data, dataBase, baseOffsets, baseOffsetsLength);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor calculate_partial_sums_dot_f32_512$descriptor() {
        return calculate_partial_sums_dot_f32_512.DESC;
    }

    public static MethodHandle calculate_partial_sums_dot_f32_512$handle() {
        return calculate_partial_sums_dot_f32_512.HANDLE;
    }

    public static void calculate_partial_sums_dot_f32_512(MemorySegment codebook, int codebookBase, int size, int clusterCount, MemorySegment query, int queryOffset, MemorySegment partialSums) {
        MethodHandle mh$ = calculate_partial_sums_dot_f32_512.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                NativeSimdOps.traceDowncall("calculate_partial_sums_dot_f32_512", codebook, codebookBase, size, clusterCount, query, queryOffset, partialSums);
            }
            mh$.invokeExact(codebook, codebookBase, size, clusterCount, query, queryOffset, partialSums);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor calculate_partial_sums_euclidean_f32_512$descriptor() {
        return calculate_partial_sums_euclidean_f32_512.DESC;
    }

    public static MethodHandle calculate_partial_sums_euclidean_f32_512$handle() {
        return calculate_partial_sums_euclidean_f32_512.HANDLE;
    }

    public static void calculate_partial_sums_euclidean_f32_512(MemorySegment codebook, int codebookBase, int size, int clusterCount, MemorySegment query, int queryOffset, MemorySegment partialSums) {
        MethodHandle mh$ = calculate_partial_sums_euclidean_f32_512.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                NativeSimdOps.traceDowncall("calculate_partial_sums_euclidean_f32_512", codebook, codebookBase, size, clusterCount, query, queryOffset, partialSums);
            }
            mh$.invokeExact(codebook, codebookBase, size, clusterCount, query, queryOffset, partialSums);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor dot_product_multi_f32_512$descriptor() {
        return dot_product_multi_f32_512.DESC;
    }

    public static MethodHandle dot_product_multi_f32_512$handle() {
        return dot_product_multi_f32_512.HANDLE;
    }

    public static void dot_product_multi_f32_512(MemorySegment v1, MemorySegment packedv2, int v1Length, int resultsLength, MemorySegment results) {
        MethodHandle mh$ = dot_product_multi_f32_512.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                NativeSimdOps.traceDowncall("dot_product_multi_f32_512", v1, packedv2, v1Length, resultsLength, results);
            }
            mh$.invokeExact(v1, packedv2, v1Length, resultsLength, results);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor square_distance_multi_f32_512$descriptor() {
        return square_distance_multi_f32_512.DESC;
    }

    public static MethodHandle square_distance_multi_f32_512$handle() {
        return square_distance_multi_f32_512.HANDLE;
    }

    public static void square_distance_multi_f32_512(MemorySegment v1, MemorySegment packedv2, int v1Length, int resultsLength, MemorySegment results) {
        MethodHandle mh$ = square_distance_multi_f32_512.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                NativeSimdOps.traceDowncall("square_distance_multi_f32_512", v1, packedv2, v1Length, resultsLength, results);
            }
            mh$.invokeExact(v1, packedv2, v1Length, resultsLength, results);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    private static class check_compatibility {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_BOOL, new MemoryLayout[0]);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(NativeSimdOps.findOrThrow("check_compatibility"), DESC, Linker.Option.critical((boolean)true));

        private check_compatibility() {
        }
    }

    private static class dot_product_f32 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_FLOAT, C_INT, C_POINTER, C_INT, C_POINTER, C_INT, C_INT);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(NativeSimdOps.findOrThrow("dot_product_f32"), DESC, Linker.Option.critical((boolean)true));

        private dot_product_f32() {
        }
    }

    private static class euclidean_f32 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_FLOAT, C_INT, C_POINTER, C_INT, C_POINTER, C_INT, C_INT);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(NativeSimdOps.findOrThrow("euclidean_f32"), DESC, Linker.Option.critical((boolean)true));

        private euclidean_f32() {
        }
    }

    private static class bulk_shuffle_dot_f32_512 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_INT, C_POINTER, C_POINTER);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(NativeSimdOps.findOrThrow("bulk_shuffle_dot_f32_512"), DESC, Linker.Option.critical((boolean)true));

        private bulk_shuffle_dot_f32_512() {
        }
    }

    private static class bulk_shuffle_euclidean_f32_512 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_INT, C_POINTER, C_POINTER);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(NativeSimdOps.findOrThrow("bulk_shuffle_euclidean_f32_512"), DESC, Linker.Option.critical((boolean)true));

        private bulk_shuffle_euclidean_f32_512() {
        }
    }

    private static class assemble_and_sum_f32_512 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_FLOAT, C_POINTER, C_INT, C_POINTER, C_INT);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(NativeSimdOps.findOrThrow("assemble_and_sum_f32_512"), DESC, Linker.Option.critical((boolean)true));

        private assemble_and_sum_f32_512() {
        }
    }

    private static class calculate_partial_sums_dot_f32_512 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_INT, C_INT, C_INT, C_POINTER, C_INT, C_POINTER);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(NativeSimdOps.findOrThrow("calculate_partial_sums_dot_f32_512"), DESC, Linker.Option.critical((boolean)true));

        private calculate_partial_sums_dot_f32_512() {
        }
    }

    private static class calculate_partial_sums_euclidean_f32_512 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_INT, C_INT, C_INT, C_POINTER, C_INT, C_POINTER);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(NativeSimdOps.findOrThrow("calculate_partial_sums_euclidean_f32_512"), DESC, Linker.Option.critical((boolean)true));

        private calculate_partial_sums_euclidean_f32_512() {
        }
    }

    private static class dot_product_multi_f32_512 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_POINTER, C_INT, C_INT, C_POINTER);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(NativeSimdOps.findOrThrow("dot_product_multi_f32_512"), DESC, Linker.Option.critical((boolean)true));

        private dot_product_multi_f32_512() {
        }
    }

    private static class square_distance_multi_f32_512 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_POINTER, C_INT, C_INT, C_POINTER);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(NativeSimdOps.findOrThrow("square_distance_multi_f32_512"), DESC, Linker.Option.critical((boolean)true));

        private square_distance_multi_f32_512() {
        }
    }
}

