/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class ExplicitThreadLocal<U>
implements AutoCloseable {
    private final ConcurrentHashMap<Long, U> map = new ConcurrentHashMap();
    private final Function<Long, U> initialSupplier = k -> this.initialValue();

    public U get() {
        return this.map.computeIfAbsent(Thread.currentThread().getId(), this.initialSupplier);
    }

    protected abstract U initialValue();

    @Override
    public void close() throws Exception {
        for (U value : this.map.values()) {
            if (!(value instanceof AutoCloseable)) continue;
            ((AutoCloseable)value).close();
        }
        this.map.clear();
    }

    public static <U> ExplicitThreadLocal<U> withInitial(final Supplier<U> initialValue) {
        return new ExplicitThreadLocal<U>(){

            @Override
            protected U initialValue() {
                return initialValue.get();
            }
        };
    }
}

