/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph.similarity;

import io.github.jbellis.jvector.graph.RandomAccessVectorValues;
import io.github.jbellis.jvector.vector.VectorSimilarityFunction;
import io.github.jbellis.jvector.vector.VectorizationProvider;
import io.github.jbellis.jvector.vector.types.VectorFloat;
import io.github.jbellis.jvector.vector.types.VectorTypeSupport;

public interface ScoreFunction {
    public static final VectorTypeSupport vts = VectorizationProvider.getInstance().getVectorTypeSupport();

    public boolean isExact();

    public float similarityTo(int var1);

    default public VectorFloat<?> edgeLoadingSimilarityTo(int node2) {
        throw new UnsupportedOperationException("bulk similarity not supported");
    }

    default public boolean supportsEdgeLoadingSimilarity() {
        return false;
    }

    public static interface Provider {
        public ScoreFunction scoreFunctionFor(int var1);
    }

    public static interface ApproximateScoreFunction
    extends ScoreFunction {
        @Override
        default public boolean isExact() {
            return false;
        }
    }

    public static interface ExactScoreFunction
    extends ScoreFunction {
        @Override
        default public boolean isExact() {
            return true;
        }

        public VectorFloat<?> similarityTo(int[] var1);

        public static ExactScoreFunction from(final VectorFloat<?> queryVector, final VectorSimilarityFunction vsf, final RandomAccessVectorValues vp) {
            return new ExactScoreFunction(){

                @Override
                public VectorFloat<?> similarityTo(int[] nodes) {
                    VectorFloat<?> results = vts.createFloatVector(nodes.length);
                    int nodeCount = nodes.length;
                    int dimension = queryVector.length();
                    VectorFloat<?> packedVectors = vts.createFloatVector(nodeCount * dimension);
                    for (int i1 = 0; i1 < nodeCount; ++i1) {
                        int node = nodes[i1];
                        vp.getVectorInto(node, packedVectors, i1 * dimension);
                    }
                    vsf.compareMulti(queryVector, packedVectors, results);
                    return results;
                }

                @Override
                public float similarityTo(int node2) {
                    return vsf.compare(queryVector, vp.getVector(node2));
                }
            };
        }
    }
}

