/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph.disk;

import io.github.jbellis.jvector.disk.RandomAccessReader;
import io.github.jbellis.jvector.graph.GraphIndex;
import io.github.jbellis.jvector.graph.NodesIterator;
import io.github.jbellis.jvector.graph.disk.CommonHeader;
import io.github.jbellis.jvector.graph.disk.Feature;
import io.github.jbellis.jvector.graph.disk.FeatureId;
import io.github.jbellis.jvector.graph.disk.FusedADCNeighbors;
import io.github.jbellis.jvector.graph.disk.OnDiskGraphIndex;
import io.github.jbellis.jvector.graph.similarity.ScoreFunction;
import io.github.jbellis.jvector.pq.PQVectors;
import io.github.jbellis.jvector.pq.ProductQuantization;
import io.github.jbellis.jvector.pq.QuickADCPQDecoder;
import io.github.jbellis.jvector.vector.VectorSimilarityFunction;
import io.github.jbellis.jvector.vector.VectorizationProvider;
import io.github.jbellis.jvector.vector.types.ByteSequence;
import io.github.jbellis.jvector.vector.types.VectorFloat;
import io.github.jbellis.jvector.vector.types.VectorTypeSupport;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UncheckedIOException;

public class FusedADC
implements Feature {
    private static final VectorTypeSupport vectorTypeSupport = VectorizationProvider.getInstance().getVectorTypeSupport();
    private final ProductQuantization pq;
    private final int maxDegree;
    private final ThreadLocal<VectorFloat<?>> reusableResults;
    private ByteSequence<?> compressedNeighbors = null;

    public FusedADC(int maxDegree, ProductQuantization pq) {
        this.maxDegree = maxDegree;
        this.pq = pq;
        this.reusableResults = ThreadLocal.withInitial(() -> OnDiskGraphIndex.vectorTypeSupport.createFloatVector(maxDegree));
    }

    @Override
    public FeatureId id() {
        return FeatureId.FUSED_ADC;
    }

    @Override
    public int headerSize() {
        return this.pq.compressorSize();
    }

    @Override
    public int inlineSize() {
        return this.pq.compressedVectorSize() * this.maxDegree;
    }

    static FusedADC load(CommonHeader header, RandomAccessReader reader) {
        try {
            return new FusedADC(header.maxDegree, ProductQuantization.load(reader));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    ScoreFunction.ApproximateScoreFunction approximateScoreFunctionFor(VectorFloat<?> queryVector, VectorSimilarityFunction vsf, OnDiskGraphIndex.View view, ScoreFunction.ExactScoreFunction esf) {
        PackedNeighborsFused neighbors = new PackedNeighborsFused(view);
        return QuickADCPQDecoder.newDecoder(neighbors, this.pq, queryVector, this.reusableResults.get(), vsf, esf);
    }

    @Override
    public void writeHeader(DataOutput out) throws IOException {
        this.pq.write(out);
    }

    @Override
    public void writeInline(DataOutput out, Feature.State state_) throws IOException {
        if (this.compressedNeighbors == null) {
            this.compressedNeighbors = vectorTypeSupport.createByteSequence(this.pq.compressedVectorSize() * this.maxDegree);
        }
        State state = (State)state_;
        PQVectors pqv = state.pqVectors;
        NodesIterator neighbors = state.view.getNeighborsIterator(state.nodeId);
        int neighborSize = neighbors.size();
        this.compressedNeighbors.zero();
        for (int n = 0; n < neighborSize; ++n) {
            ByteSequence<?> compressed = pqv.get(neighbors.nextInt());
            for (int j = 0; j < pqv.getCompressedSize(); ++j) {
                this.compressedNeighbors.set(j * this.maxDegree + n, compressed.get(j));
            }
        }
        vectorTypeSupport.writeByteSequence(out, this.compressedNeighbors);
    }

    private class PackedNeighborsFused
    implements FusedADCNeighbors {
        private final OnDiskGraphIndex.View view;
        private final ByteSequence<?> neighbors;

        public PackedNeighborsFused(OnDiskGraphIndex.View view) {
            this.view = view;
            this.neighbors = OnDiskGraphIndex.vectorTypeSupport.createByteSequence(FusedADC.this.pq.compressedVectorSize() * FusedADC.this.maxDegree);
        }

        @Override
        public ByteSequence<?> getPackedNeighbors(int node) {
            RandomAccessReader reader = this.view.inlineReaderForNode(node, FeatureId.FUSED_ADC);
            try {
                OnDiskGraphIndex.vectorTypeSupport.readByteSequence(reader, this.neighbors);
                return this.neighbors;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class State
    implements Feature.State {
        public final GraphIndex.View view;
        public final PQVectors pqVectors;
        public final int nodeId;

        public State(GraphIndex.View view, PQVectors pqVectors, int nodeId) {
            this.view = view;
            this.pqVectors = pqVectors;
            this.nodeId = nodeId;
        }
    }
}

