/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.disk;

import io.github.jbellis.jvector.graph.GraphIndex;
import io.github.jbellis.jvector.graph.NodesIterator;
import io.github.jbellis.jvector.util.Accountable;
import io.github.jbellis.jvector.util.RamUsageEstimator;
import java.io.IOException;
import org.agrona.collections.Int2ObjectHashMap;

public abstract class GraphCache
implements Accountable {
    public abstract CachedNode getNode(int var1);

    public static GraphCache load(GraphIndex<float[]> graph, int distance) throws IOException {
        if (distance < 0) {
            return new EmptyGraphCache();
        }
        return new HMGraphCache(graph, distance);
    }

    @Override
    public abstract long ramBytesUsed();

    private static final class EmptyGraphCache
    extends GraphCache {
        private EmptyGraphCache() {
        }

        @Override
        public CachedNode getNode(int ordinal) {
            return null;
        }

        @Override
        public long ramBytesUsed() {
            return 0L;
        }
    }

    private static final class HMGraphCache
    extends GraphCache {
        private final Int2ObjectHashMap<CachedNode> cache;
        private long ramBytesUsed = 0L;

        public HMGraphCache(GraphIndex<float[]> graph, int distance) {
            try (GraphIndex.View<float[]> view = graph.getView();){
                Int2ObjectHashMap tmpCache = new Int2ObjectHashMap();
                this.cacheNeighborsOf((Int2ObjectHashMap<CachedNode>)tmpCache, view, view.entryNode(), distance);
                this.cache = tmpCache;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private void cacheNeighborsOf(Int2ObjectHashMap<CachedNode> tmpCache, GraphIndex.View<float[]> view, int ordinal, int distance) {
            NodesIterator it = view.getNeighborsIterator(ordinal);
            int[] neighbors = new int[it.size()];
            int i = 0;
            while (it.hasNext()) {
                neighbors[i++] = it.nextInt();
            }
            CachedNode node = new CachedNode(view.getVector(ordinal), neighbors);
            tmpCache.put(ordinal, (Object)node);
            this.ramBytesUsed += (long)(4 + RamUsageEstimator.NUM_BYTES_OBJECT_REF) + RamUsageEstimator.sizeOf(node.vector) + RamUsageEstimator.sizeOf(node.neighbors);
            if (distance > 0) {
                for (int neighbor : neighbors) {
                    if (tmpCache.containsKey(neighbor)) continue;
                    this.cacheNeighborsOf(tmpCache, view, neighbor, distance - 1);
                }
            }
        }

        @Override
        public CachedNode getNode(int ordinal) {
            return (CachedNode)this.cache.get(ordinal);
        }

        @Override
        public long ramBytesUsed() {
            return this.ramBytesUsed;
        }
    }

    public static final class CachedNode {
        public final float[] vector;
        public final int[] neighbors;

        public CachedNode(float[] vector, int[] neighbors) {
            this.vector = vector;
            this.neighbors = neighbors;
        }
    }
}

