/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.util;

import io.github.jbellis.jvector.util.BitSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SynchronizedGrowableBitSet
extends BitSet {
    private final java.util.BitSet bitSet;
    private final Lock lock = new ReentrantLock();

    public SynchronizedGrowableBitSet(java.util.BitSet bitSet) {
        this.bitSet = bitSet;
    }

    public SynchronizedGrowableBitSet(int initialBits) {
        this.bitSet = new java.util.BitSet(initialBits);
    }

    @Override
    public void clear(int index) {
        this.lock.lock();
        try {
            this.bitSet.clear(index);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            this.bitSet.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean get(int index) {
        this.lock.lock();
        try {
            boolean bl = this.bitSet.get(index);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getAndSet(int index) {
        this.lock.lock();
        try {
            boolean v = this.get(index);
            this.set(index);
            boolean bl = v;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int length() {
        this.lock.lock();
        try {
            int n = this.bitSet.length();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void set(int i) {
        this.lock.lock();
        try {
            this.bitSet.set(i);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear(int startIndex, int endIndex) {
        this.lock.lock();
        try {
            if (startIndex == 0 && endIndex == this.bitSet.length()) {
                this.bitSet.clear();
                return;
            }
            if (startIndex >= endIndex) {
                return;
            }
            this.bitSet.clear(startIndex, endIndex);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int cardinality() {
        this.lock.lock();
        try {
            int n = this.bitSet.cardinality();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int approximateCardinality() {
        this.lock.lock();
        try {
            int n = this.bitSet.cardinality();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int prevSetBit(int index) {
        this.lock.lock();
        try {
            int n = this.bitSet.previousSetBit(index);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int nextSetBit(int i) {
        this.lock.lock();
        try {
            int next = this.bitSet.nextSetBit(i);
            if (next == -1) {
                next = Integer.MAX_VALUE;
            }
            int n = next;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long ramBytesUsed() {
        throw new UnsupportedOperationException();
    }
}

