/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph;

import io.github.jbellis.jvector.annotations.VisibleForTesting;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.stat.StatUtils;

interface ScoreTracker {
    public static final ScoreTracker NO_OP = new NoOpTracker();

    public void track(float var1);

    public boolean shouldStop(int var1);

    public static class NoOpTracker
    implements ScoreTracker {
        @Override
        public void track(float score) {
        }

        @Override
        public boolean shouldStop(int numVisited) {
            return false;
        }
    }

    public static class NormalDistributionTracker
    implements ScoreTracker {
        @VisibleForTesting
        static final int RECENT_SCORES_TRACKED = 300;
        private final double[] recentScores = new double[300];
        private int index;
        private final double threshold;

        NormalDistributionTracker(double threshold) {
            this.threshold = threshold;
        }

        @Override
        public void track(float score) {
            this.recentScores[this.index] = score;
            this.index = (this.index + 1) % this.recentScores.length;
        }

        @Override
        public boolean shouldStop(int numVisited) {
            if (numVisited < this.recentScores.length) {
                return false;
            }
            return numVisited % 100 == 0 && NormalDistributionTracker.futureProbabilityAboveThreshold(this.recentScores, this.threshold) < 0.01;
        }

        @VisibleForTesting
        static double futureProbabilityAboveThreshold(double[] recentSimilarities, double threshold) {
            double sampleMean = StatUtils.mean((double[])recentSimilarities);
            double sampleStd = Math.sqrt(StatUtils.variance((double[])recentSimilarities));
            double zScore = (threshold - sampleMean) / sampleStd;
            NormalDistribution normalDistribution = new NormalDistribution(sampleMean, sampleStd);
            return 1.0 - normalDistribution.cumulativeProbability(zScore);
        }
    }
}

