/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph;

import io.github.jbellis.jvector.graph.ConcurrentNeighborSet;
import io.github.jbellis.jvector.graph.GraphIndex;
import io.github.jbellis.jvector.graph.NodesIterator;
import io.github.jbellis.jvector.util.Accountable;
import io.github.jbellis.jvector.util.BitSet;
import io.github.jbellis.jvector.util.Bits;
import io.github.jbellis.jvector.util.DenseIntMap;
import io.github.jbellis.jvector.util.GrowableBitSet;
import io.github.jbellis.jvector.util.RamUsageEstimator;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.stream.IntStream;

public class OnHeapGraphIndex<T>
implements GraphIndex<T>,
Accountable {
    private final AtomicInteger entryPoint = new AtomicInteger(-1);
    private final DenseIntMap<ConcurrentNeighborSet> nodes;
    private final BitSet deletedNodes = new GrowableBitSet(0);
    private final AtomicInteger maxNodeId = new AtomicInteger(-1);
    final int maxDegree;
    private final BiFunction<Integer, Integer, ConcurrentNeighborSet> neighborFactory;

    OnHeapGraphIndex(int M, BiFunction<Integer, Integer, ConcurrentNeighborSet> neighborFactory) {
        this.neighborFactory = neighborFactory;
        this.maxDegree = 2 * M;
        this.nodes = new DenseIntMap(1024);
    }

    ConcurrentNeighborSet getNeighbors(int node) {
        return this.nodes.get(node);
    }

    @Override
    public int size() {
        return this.nodes.size();
    }

    public ConcurrentNeighborSet addNode(int node) {
        ConcurrentNeighborSet newNeighborSet = this.neighborFactory.apply(node, this.maxDegree());
        this.nodes.put(node, newNeighborSet);
        this.maxNodeId.accumulateAndGet(node, Math::max);
        return newNeighborSet;
    }

    void addNode(int node, ConcurrentNeighborSet neighbors) {
        this.nodes.put(node, neighbors);
        this.maxNodeId.accumulateAndGet(node, Math::max);
    }

    public void markDeleted(int node) {
        this.deletedNodes.set(node);
    }

    void maybeSetInitialEntryNode(int node) {
        this.entryPoint.accumulateAndGet(node, (oldEntry, newEntry) -> {
            if (oldEntry >= 0) {
                return oldEntry;
            }
            return newEntry;
        });
    }

    void updateEntryNode(int node) {
        this.entryPoint.set(node);
    }

    @Override
    public int maxDegree() {
        return this.maxDegree;
    }

    int entry() {
        return this.entryPoint.get();
    }

    @Override
    public NodesIterator getNodes() {
        return this.nodes.getNodesIterator();
    }

    @Override
    public long ramBytesUsed() {
        long total = (long)this.size() * (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF;
        long neighborSize = OnHeapGraphIndex.neighborsRamUsed(this.maxDegree()) * (long)this.size();
        return total + neighborSize + (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER;
    }

    public long ramBytesUsedOneNode(int nodeLevel) {
        long graphBytesUsed = OnHeapGraphIndex.neighborsRamUsed(this.maxDegree()) + (long)nodeLevel * OnHeapGraphIndex.neighborsRamUsed(this.maxDegree());
        int clockBytesUsed = 4;
        return graphBytesUsed + (long)clockBytesUsed;
    }

    private static long neighborsRamUsed(int count) {
        long REF_BYTES = RamUsageEstimator.NUM_BYTES_OBJECT_REF;
        long AH_BYTES = RamUsageEstimator.NUM_BYTES_ARRAY_HEADER;
        long neighborSetBytes = REF_BYTES + 4L + 4L + REF_BYTES + AH_BYTES * 2L + REF_BYTES * 2L + 4L + 1L;
        return neighborSetBytes + (long)count * 8L;
    }

    public String toString() {
        return String.format("OnHeapGraphIndex(size=%d, entryPoint=%d)", this.size(), this.entryPoint.get());
    }

    @Override
    public void close() {
    }

    @Override
    public GraphIndex.View<T> getView() {
        return new ConcurrentGraphIndexView();
    }

    void validateEntryNode() {
        if (this.size() == 0) {
            return;
        }
        int en = this.entryPoint.get();
        if (en < 0 || this.getNeighbors(en) == null) {
            throw new IllegalStateException("Entry node was incompletely added! " + en);
        }
    }

    public BitSet getDeletedNodes() {
        return this.deletedNodes;
    }

    boolean removeNode(int node) {
        return this.nodes.remove(node) != null;
    }

    @Override
    public int getIdUpperBound() {
        return this.maxNodeId.get() + 1;
    }

    int[] rawNodes() {
        return this.nodes.keySet().stream().mapToInt(i -> i).toArray();
    }

    @Override
    public boolean containsNode(int nodeId) {
        return this.nodes.containsKey(nodeId);
    }

    public double getAverageShortEdges() {
        return IntStream.range(0, this.getIdUpperBound()).filter(this::containsNode).mapToDouble(i -> this.getNeighbors(i).getShortEdges()).average().orElse(Double.NaN);
    }

    public double getAverageDegree() {
        return IntStream.range(0, this.getIdUpperBound()).filter(this::containsNode).mapToDouble(i -> this.getNeighbors(i).size()).average().orElse(Double.NaN);
    }

    public void save(DataOutput out) throws IOException {
        if (this.deletedNodes.cardinality() > 0) {
            throw new IllegalStateException("Cannot save a graph that has deleted nodes.  Call cleanup() first");
        }
        GraphIndex.View<T> view = this.getView();
        out.writeInt(this.size());
        out.writeInt(view.entryNode());
        out.writeInt(this.maxDegree());
        for (Map.Entry<Integer, ConcurrentNeighborSet> entry : this.nodes.entrySet()) {
            int i = (int)((long)entry.getKey().intValue());
            NodesIterator neighbors = entry.getValue().iterator();
            out.writeInt(i);
            out.writeInt(neighbors.size());
            for (int n = 0; n < neighbors.size(); ++n) {
                out.writeInt(neighbors.nextInt());
            }
            assert (!neighbors.hasNext());
        }
    }

    private class ConcurrentGraphIndexView
    implements GraphIndex.View<T> {
        private ConcurrentGraphIndexView() {
        }

        @Override
        public T getVector(int node) {
            throw new UnsupportedOperationException("All searches done with OnHeapGraphIndex should be exact");
        }

        @Override
        public NodesIterator getNeighborsIterator(int node) {
            return OnHeapGraphIndex.this.getNeighbors(node).iterator();
        }

        @Override
        public int size() {
            return OnHeapGraphIndex.this.size();
        }

        @Override
        public int entryNode() {
            return OnHeapGraphIndex.this.entryPoint.get();
        }

        public String toString() {
            return "OnHeapGraphIndexView(size=" + this.size() + ", entryPoint=" + OnHeapGraphIndex.this.entryPoint.get();
        }

        @Override
        public Bits liveNodes() {
            return OnHeapGraphIndex.this.deletedNodes.cardinality() == 0 ? Bits.ALL : Bits.inverseOf(OnHeapGraphIndex.this.deletedNodes);
        }

        @Override
        public int getIdUpperBound() {
            return OnHeapGraphIndex.this.getIdUpperBound();
        }

        @Override
        public void close() {
        }
    }
}

