/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamsesso.jsonlogic.ast;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import io.github.jamsesso.jsonlogic.ast.JsonLogicArray;
import io.github.jamsesso.jsonlogic.ast.JsonLogicBoolean;
import io.github.jamsesso.jsonlogic.ast.JsonLogicNode;
import io.github.jamsesso.jsonlogic.ast.JsonLogicNull;
import io.github.jamsesso.jsonlogic.ast.JsonLogicNumber;
import io.github.jamsesso.jsonlogic.ast.JsonLogicOperation;
import io.github.jamsesso.jsonlogic.ast.JsonLogicParseException;
import io.github.jamsesso.jsonlogic.ast.JsonLogicString;
import io.github.jamsesso.jsonlogic.ast.JsonLogicVariable;
import java.util.ArrayList;
import java.util.Collections;

public final class JsonLogicParser {
    private static final JsonParser PARSER = new JsonParser();

    private JsonLogicParser() {
    }

    public static JsonLogicNode parse(String json) throws JsonLogicParseException {
        try {
            return JsonLogicParser.parse(PARSER.parse(json));
        }
        catch (JsonSyntaxException e) {
            throw new JsonLogicParseException(e, "$");
        }
    }

    private static JsonLogicNode parse(JsonElement root) throws JsonLogicParseException {
        return JsonLogicParser.parse(root, "$");
    }

    private static JsonLogicNode parse(JsonElement root, String jsonPath) throws JsonLogicParseException {
        if (root.isJsonNull()) {
            return JsonLogicNull.NULL;
        }
        if (root.isJsonPrimitive()) {
            JsonPrimitive primitive = root.getAsJsonPrimitive();
            if (primitive.isString()) {
                return new JsonLogicString(primitive.getAsString());
            }
            if (primitive.isNumber()) {
                return new JsonLogicNumber(primitive.getAsNumber());
            }
            if (primitive.isBoolean() && primitive.getAsBoolean()) {
                return JsonLogicBoolean.TRUE;
            }
            return JsonLogicBoolean.FALSE;
        }
        if (root.isJsonArray()) {
            JsonArray array = root.getAsJsonArray();
            ArrayList<JsonLogicNode> elements = new ArrayList<JsonLogicNode>(array.size());
            int index = 0;
            for (JsonElement element : array) {
                elements.add(JsonLogicParser.parse(element, String.format("%s[%d]", jsonPath, index++)));
            }
            return new JsonLogicArray(elements);
        }
        JsonObject object = root.getAsJsonObject();
        if (object.keySet().size() != 1) {
            throw new JsonLogicParseException("objects must have exactly 1 key defined, found " + object.keySet().size(), jsonPath);
        }
        String key = (String)object.keySet().stream().findAny().get();
        JsonLogicNode argumentNode = JsonLogicParser.parse(object.get(key), String.format("%s.%s", jsonPath, key));
        JsonLogicArray arguments = argumentNode instanceof JsonLogicArray ? (JsonLogicArray)argumentNode : new JsonLogicArray(Collections.singletonList(argumentNode));
        if ("var".equals(key)) {
            JsonLogicNull defaultValue = arguments.size() > 1 ? arguments.get(1) : JsonLogicNull.NULL;
            return new JsonLogicVariable(arguments.size() < 1 ? JsonLogicNull.NULL : arguments.get(0), defaultValue);
        }
        return new JsonLogicOperation(key, arguments);
    }
}

