/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamsesso.jsonlogic.evaluator.expressions;

import io.github.jamsesso.jsonlogic.evaluator.JsonLogicEvaluationException;
import io.github.jamsesso.jsonlogic.evaluator.expressions.PreEvaluatedArgumentsExpression;
import java.util.List;

public class NumericComparisonExpression
implements PreEvaluatedArgumentsExpression {
    public static final NumericComparisonExpression GT = new NumericComparisonExpression(">");
    public static final NumericComparisonExpression GTE = new NumericComparisonExpression(">=");
    public static final NumericComparisonExpression LT = new NumericComparisonExpression("<");
    public static final NumericComparisonExpression LTE = new NumericComparisonExpression("<=");
    private final String key;

    private NumericComparisonExpression(String key) {
        this.key = key;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public Object evaluate(List arguments, Object data) throws JsonLogicEvaluationException {
        int n = Math.min(arguments.size(), 3);
        if (n < 2) {
            throw new JsonLogicEvaluationException("'" + this.key + "' requires at least 2 arguments");
        }
        double[] values = new double[n];
        for (int i = 0; i < n; ++i) {
            Object value = arguments.get(i);
            if (value instanceof String) {
                try {
                    values[i] = Double.parseDouble((String)value);
                    continue;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            if (!(value instanceof Number)) {
                return false;
            }
            values[i] = ((Number)value).doubleValue();
        }
        if (arguments.size() == 3) {
            switch (this.key) {
                case "<": {
                    return values[0] < values[1] && values[1] < values[2];
                }
                case "<=": {
                    return values[0] <= values[1] && values[1] <= values[2];
                }
            }
            throw new JsonLogicEvaluationException("'" + this.key + "' does not support between comparisons");
        }
        switch (this.key) {
            case "<": {
                return values[0] < values[1];
            }
            case "<=": {
                return values[0] <= values[1];
            }
            case ">": {
                return values[0] > values[1];
            }
            case ">=": {
                return values[0] >= values[1];
            }
        }
        throw new JsonLogicEvaluationException("'" + this.key + "' is not a comparison expression");
    }
}

