/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamsesso.jsonlogic.evaluator.expressions;

import io.github.jamsesso.jsonlogic.JsonLogic;
import io.github.jamsesso.jsonlogic.ast.JsonLogicArray;
import io.github.jamsesso.jsonlogic.evaluator.JsonLogicEvaluationException;
import io.github.jamsesso.jsonlogic.evaluator.JsonLogicEvaluator;
import io.github.jamsesso.jsonlogic.evaluator.JsonLogicExpression;
import io.github.jamsesso.jsonlogic.utils.ArrayLike;
import java.util.ArrayList;

public class FilterExpression
implements JsonLogicExpression {
    public static final FilterExpression INSTANCE = new FilterExpression();

    private FilterExpression() {
    }

    @Override
    public String key() {
        return "filter";
    }

    @Override
    public Object evaluate(JsonLogicEvaluator evaluator, JsonLogicArray arguments, Object data) throws JsonLogicEvaluationException {
        if (arguments.size() != 2) {
            throw new JsonLogicEvaluationException("filter expects exactly 2 arguments");
        }
        Object maybeArray = evaluator.evaluate(arguments.get(0), data);
        if (!ArrayLike.isEligible(maybeArray)) {
            throw new JsonLogicEvaluationException("first argument to filter must be a valid array");
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object item : new ArrayLike(maybeArray)) {
            if (!JsonLogic.truthy(evaluator.evaluate(arguments.get(1), item))) continue;
            result.add(item);
        }
        return result;
    }
}

