/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamsesso.jsonlogic.evaluator.expressions;

import io.github.jamsesso.jsonlogic.JsonLogic;
import io.github.jamsesso.jsonlogic.evaluator.JsonLogicEvaluationException;
import io.github.jamsesso.jsonlogic.evaluator.expressions.PreEvaluatedArgumentsExpression;
import java.util.List;

public class EqualityExpression
implements PreEvaluatedArgumentsExpression {
    public static final EqualityExpression INSTANCE = new EqualityExpression();

    private EqualityExpression() {
    }

    @Override
    public String key() {
        return "==";
    }

    @Override
    public Object evaluate(List arguments, Object data) throws JsonLogicEvaluationException {
        if (arguments.size() != 2) {
            throw new JsonLogicEvaluationException("equality expressions expect exactly 2 arguments");
        }
        Object left = arguments.get(0);
        Object right = arguments.get(1);
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left instanceof Number && right instanceof Number) {
            return Double.valueOf(((Number)left).doubleValue()).equals(((Number)right).doubleValue());
        }
        if (left instanceof Number && right instanceof String) {
            return this.compareNumberToString((Number)left, (String)right);
        }
        if (left instanceof Number && right instanceof Boolean) {
            return this.compareNumberToBoolean((Number)left, (Boolean)right);
        }
        if (left instanceof String && right instanceof String) {
            return left.equals(right);
        }
        if (left instanceof String && right instanceof Number) {
            return this.compareNumberToString((Number)right, (String)left);
        }
        if (left instanceof String && right instanceof Boolean) {
            return this.compareStringToBoolean((String)left, (Boolean)right);
        }
        if (left instanceof Boolean && right instanceof Boolean) {
            return ((Boolean)left).booleanValue() == ((Boolean)right).booleanValue();
        }
        if (left instanceof Boolean && right instanceof Number) {
            return this.compareNumberToBoolean((Number)right, (Boolean)left);
        }
        if (left instanceof Boolean && right instanceof String) {
            return this.compareStringToBoolean((String)right, (Boolean)left);
        }
        return !JsonLogic.truthy(left) && !JsonLogic.truthy(right);
    }

    private boolean compareNumberToString(Number left, String right) {
        try {
            if (right.trim().isEmpty()) {
                right = "0";
            }
            return Double.parseDouble(right) == left.doubleValue();
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean compareNumberToBoolean(Number left, Boolean right) {
        if (right.booleanValue()) {
            return left.doubleValue() == 1.0;
        }
        return left.doubleValue() == 0.0;
    }

    private boolean compareStringToBoolean(String left, Boolean right) {
        return JsonLogic.truthy(left) == right;
    }
}

