/*
 * Decompiled with CFR 0.152.
 */
package io.github.home4j.lightext;

import io.github.home4j.lightext.Default;
import io.github.home4j.lightext.Holder;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightExtLoader<T> {
    private static final Logger logger = LoggerFactory.getLogger(LightExtLoader.class);
    private static final String SERVICES_DIRECTORY = "META-INF/lightext/";
    private static final ConcurrentMap<Class<?>, LightExtLoader<?>> EXTENSION_LOADERS = new ConcurrentHashMap();
    private static final ConcurrentMap<Class<?>, Object> EXTENSION_INSTANCES = new ConcurrentHashMap();
    private final Class<?> type;
    private final String defaultName;
    private final Holder<Map<String, Class<?>>> cachedClasses = new Holder();
    private final ConcurrentMap<String, Holder<Object>> cachedInstances = new ConcurrentHashMap<String, Holder<Object>>();

    public static <T> LightExtLoader<T> getExtensionLoader(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Extension type == null");
        }
        if (!type.isInterface()) {
            throw new IllegalArgumentException("Extension type(" + type + ") is not interface!");
        }
        LightExtLoader loader = (LightExtLoader)EXTENSION_LOADERS.get(type);
        if (loader == null) {
            Default anno = type.getAnnotation(Default.class);
            String defaultName = null == anno ? null : anno.value();
            EXTENSION_LOADERS.putIfAbsent(type, new LightExtLoader<T>(type, defaultName));
            loader = (LightExtLoader)EXTENSION_LOADERS.get(type);
        }
        return loader;
    }

    private LightExtLoader(Class<?> type, String defaultName) {
        this.type = type;
        if (null != defaultName && StringUtils.isBlank((CharSequence)defaultName)) {
            throw new IllegalArgumentException("Default extension name for type(" + type + ") is blank!");
        }
        this.defaultName = StringUtils.trimToNull((String)defaultName);
    }

    public T getDefaultExtension() {
        if (null == this.defaultName) {
            throw new IllegalStateException("No default extension for " + this.type.getName());
        }
        return (T)this.getExtension(this.defaultName);
    }

    public String getDefaultName() {
        return this.defaultName;
    }

    public Set<String> getLoadedExtensions() {
        return Collections.unmodifiableSet(new TreeSet(this.cachedInstances.keySet()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S extends T> S getExtension(String name) {
        Object instance;
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Extension name == null");
        }
        Holder holder = (Holder)this.cachedInstances.get(name);
        if (holder == null) {
            this.cachedInstances.putIfAbsent(name, new Holder());
            holder = (Holder)this.cachedInstances.get(name);
        }
        if ((instance = holder.get()) == null) {
            Holder holder2 = holder;
            synchronized (holder2) {
                instance = holder.get();
                if (instance == null) {
                    instance = this.createExtension(name);
                    holder.set(instance);
                }
            }
        }
        return (S)instance;
    }

    public boolean hasExtension(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Extension name == null");
        }
        try {
            return this.getExtensionClass(name) != null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public Set<String> getSupportedExtensions() {
        Map<String, Class<?>> clazzes = this.getExtensionClasses();
        return Collections.unmodifiableSet(new TreeSet<String>(clazzes.keySet()));
    }

    private T createExtension(String name) {
        Class<?> clazz = this.getExtensionClasses().get(name);
        if (clazz == null) {
            throw new IllegalStateException("No such extension " + this.type.getName() + " by name " + name);
        }
        try {
            Object instance = EXTENSION_INSTANCES.get(clazz);
            if (instance == null) {
                EXTENSION_INSTANCES.putIfAbsent(clazz, clazz.newInstance());
                instance = EXTENSION_INSTANCES.get(clazz);
            }
            return (T)instance;
        }
        catch (Throwable t) {
            throw new IllegalStateException("Extension instance(name: " + name + ", class: " + this.type + ")  could not be instantiated: " + t.getMessage(), t);
        }
    }

    private Class<?> getExtensionClass(String name) {
        if (this.type == null) {
            throw new IllegalArgumentException("Extension type == null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Extension name == null");
        }
        Class<?> clazz = this.getExtensionClasses().get(name);
        if (clazz == null) {
            throw new IllegalStateException("No such extension \"" + name + "\" for " + this.type.getName() + "!");
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Class<?>> getExtensionClasses() {
        Map<String, Class<?>> classes = this.cachedClasses.get();
        if (classes == null) {
            Holder<Map<String, Class<?>>> holder = this.cachedClasses;
            synchronized (holder) {
                classes = this.cachedClasses.get();
                if (classes == null) {
                    classes = this.loadExtensionClasses();
                    this.cachedClasses.set(classes);
                }
            }
        }
        return classes;
    }

    private Map<String, Class<?>> loadExtensionClasses() {
        HashMap extensionClasses = new HashMap();
        this.loadFile(extensionClasses, SERVICES_DIRECTORY);
        return extensionClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFile(Map<String, Class<?>> extensionClasses, String dir) {
        String fileName = dir + this.type.getName();
        try {
            ClassLoader classLoader = LightExtLoader.findClassLoader();
            Enumeration<URL> urls = classLoader != null ? classLoader.getResources(fileName) : ClassLoader.getSystemResources(fileName);
            if (urls != null) {
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), "utf-8"));){
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            int ci = line.indexOf(35);
                            if (ci >= 0) {
                                line = line.substring(0, ci);
                            }
                            if ((line = line.trim()).length() <= 0) continue;
                            String name = null;
                            int i = line.indexOf(61);
                            if (i > 0) {
                                name = line.substring(0, i).trim();
                                line = line.substring(i + 1).trim();
                            }
                            if (line.length() <= 0) continue;
                            Class<?> clazz = Class.forName(line, true, classLoader);
                            if (!this.type.isAssignableFrom(clazz)) {
                                throw new IllegalStateException("Error when load extension class(interface: " + this.type + ", class line: " + clazz.getName() + "), class " + clazz.getName() + "is not subtype of interface.");
                            }
                            Class<?> c = extensionClasses.get(name);
                            if (c == null) {
                                extensionClasses.put(name, clazz);
                                continue;
                            }
                            throw new IllegalStateException("Duplicate extension " + this.type.getName() + " name " + name + " on " + c.getName() + " and " + clazz.getName());
                        }
                    }
                    catch (Throwable t) {
                        logger.error("Exception when load extension class(interface: " + this.type + ", class file: " + url + ") in " + url, t);
                    }
                }
            }
        }
        catch (Throwable t) {
            logger.error("Exception when load extension class(interface: " + this.type + ", description file: " + fileName + ").", t);
        }
    }

    private static ClassLoader findClassLoader() {
        return LightExtLoader.class.getClassLoader();
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.type.getName() + "]";
    }
}

