/*
 * Decompiled with CFR 0.152.
 */
package com.github.hanseter.quadtree.impl;

import com.github.hanseter.quadtree.QuadtreeOptions;
import com.github.hanseter.quadtree.impl.Entry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ4\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00142\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u0016\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0002J(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u0018\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004H\u0002J\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fJ4\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001fJ$\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00042\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001fJ\u0014\u0010 \u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fJ&\u0010!\u001a\u00020\u00162\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u0014\u0010\"\u001a\u00020\u001d2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fJ\b\u0010#\u001a\u00020\u001dH\u0002R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000f0\u000ej\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/github/hanseter/quadtree/impl/Quadrant;", "T", "", "minX", "", "minY", "maxX", "maxY", "options", "Lcom/github/hanseter/quadtree/QuadtreeOptions;", "(DDDDLcom/github/hanseter/quadtree/QuadtreeOptions;)V", "bottomLeft", "bottomRight", "entries", "Ljava/util/ArrayList;", "Lcom/github/hanseter/quadtree/impl/Entry;", "Lkotlin/collections/ArrayList;", "topLeft", "topRight", "calcMid", "Lkotlin/Pair;", "canContain", "", "entry", "contains", "x", "y", "createLargerQuadrant", "find", "", "list", "", "insert", "intersects", "remove", "splitQuadrant", "quadtree"})
@SourceDebugExtension(value={"SMAP\nQuadrant.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Quadrant.kt\ncom/github/hanseter/quadtree/impl/Quadrant\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,154:1\n1855#2,2:155\n1855#2,2:157\n1855#2,2:159\n*S KotlinDebug\n*F\n+ 1 Quadrant.kt\ncom/github/hanseter/quadtree/impl/Quadrant\n*L\n49#1:155,2\n80#1:157,2\n94#1:159,2\n*E\n"})
public final class Quadrant<T> {
    private final double minX;
    private final double minY;
    private final double maxX;
    private final double maxY;
    @NotNull
    private final QuadtreeOptions options;
    @NotNull
    private final ArrayList<Entry<T>> entries;
    @Nullable
    private Quadrant<T> topLeft;
    @Nullable
    private Quadrant<T> topRight;
    @Nullable
    private Quadrant<T> bottomRight;
    @Nullable
    private Quadrant<T> bottomLeft;

    public Quadrant(double minX, double minY, double maxX, double maxY, @NotNull QuadtreeOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
        this.options = options;
        this.entries = new ArrayList();
    }

    public final boolean insert(@NotNull Entry<T> entry) {
        Intrinsics.checkNotNullParameter(entry, (String)"entry");
        if (!this.canContain(entry)) {
            return false;
        }
        if (this.topLeft != null) {
            Quadrant<T> quadrant = this.topLeft;
            Intrinsics.checkNotNull(quadrant);
            if (!quadrant.insert(entry)) {
                Quadrant<T> quadrant2 = this.topRight;
                Intrinsics.checkNotNull(quadrant2);
                if (!quadrant2.insert(entry)) {
                    Quadrant<T> quadrant3 = this.bottomRight;
                    Intrinsics.checkNotNull(quadrant3);
                    if (!quadrant3.insert(entry)) {
                        Quadrant<T> quadrant4 = this.bottomLeft;
                        Intrinsics.checkNotNull(quadrant4);
                        if (!quadrant4.insert(entry)) {
                            this.entries.add(entry);
                            entry.setContainingQuadrant(this);
                        }
                    }
                }
            }
            return true;
        }
        this.entries.add(entry);
        entry.setContainingQuadrant(this);
        if (this.entries.size() > this.options.getMaxElemsPerQuadrant()) {
            this.splitQuadrant();
        }
        return true;
    }

    private final void splitQuadrant() {
        double midX = this.minX / (double)2 + this.maxX / (double)2;
        double midY = this.minY / (double)2 + this.maxY / (double)2;
        this.topLeft = new Quadrant<T>(this.minX, this.minY, midX, midY, this.options);
        this.topRight = new Quadrant<T>(midX, this.minY, this.maxX, midY, this.options);
        this.bottomRight = new Quadrant<T>(midX, midY, this.maxX, this.maxY, this.options);
        this.bottomLeft = new Quadrant<T>(this.minX, midY, midX, this.maxY, this.options);
        List tmp = CollectionsKt.toList((Iterable)this.entries);
        this.entries.clear();
        Iterable $this$forEach$iv = tmp;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entry it = (Entry)element$iv;
            boolean bl = false;
            this.insert(it);
        }
    }

    private final boolean canContain(Entry<T> entry) {
        return this.minX <= entry.getMinX() && this.minY <= entry.getMinY() && this.maxX >= entry.getMaxX() && this.maxY >= entry.getMaxY();
    }

    private final boolean canContain(double minX, double minY, double maxX, double maxY) {
        return this.minX <= minX && this.minY <= minY && this.maxX >= maxX && this.maxY >= maxY;
    }

    public final boolean intersects(double minX, double minY, double maxX, double maxY) {
        return this.minX <= maxX && minX <= this.maxX && this.minY <= maxY && minY <= this.maxY;
    }

    private final boolean contains(double x, double y) {
        return this.minX <= x && x <= this.maxX && this.minY <= y && y <= this.maxY;
    }

    public final void find(double x, double y, @NotNull List<T> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        if (!this.contains(x, y)) {
            return;
        }
        Iterable $this$forEach$iv = this.entries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entry it = (Entry)element$iv;
            boolean bl = false;
            if (!it.contains(x, y)) continue;
            ((Collection)list).add(it.getValue());
        }
        if (this.topLeft == null) {
            return;
        }
        Quadrant<T> quadrant = this.topLeft;
        Intrinsics.checkNotNull(quadrant);
        quadrant.find(x, y, list);
        Quadrant<T> quadrant2 = this.topRight;
        Intrinsics.checkNotNull(quadrant2);
        quadrant2.find(x, y, list);
        Quadrant<T> quadrant3 = this.bottomRight;
        Intrinsics.checkNotNull(quadrant3);
        quadrant3.find(x, y, list);
        Quadrant<T> quadrant4 = this.bottomLeft;
        Intrinsics.checkNotNull(quadrant4);
        quadrant4.find(x, y, list);
    }

    public final void find(double minX, double minY, double maxX, double maxY, @NotNull List<T> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        if (!this.intersects(minX, minY, maxX, maxY)) {
            return;
        }
        Iterable $this$forEach$iv = this.entries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entry it = (Entry)element$iv;
            boolean bl = false;
            if (!it.intersects(minX, minY, maxX, maxY)) continue;
            ((Collection)list).add(it.getValue());
        }
        if (this.topLeft == null) {
            return;
        }
        Quadrant<T> quadrant = this.topLeft;
        Intrinsics.checkNotNull(quadrant);
        quadrant.find(minX, minY, maxX, maxY, list);
        Quadrant<T> quadrant2 = this.topRight;
        Intrinsics.checkNotNull(quadrant2);
        quadrant2.find(minX, minY, maxX, maxY, list);
        Quadrant<T> quadrant3 = this.bottomRight;
        Intrinsics.checkNotNull(quadrant3);
        quadrant3.find(minX, minY, maxX, maxY, list);
        Quadrant<T> quadrant4 = this.bottomLeft;
        Intrinsics.checkNotNull(quadrant4);
        quadrant4.find(minX, minY, maxX, maxY, list);
    }

    public final void remove(@NotNull Entry<T> entry) {
        Intrinsics.checkNotNullParameter(entry, (String)"entry");
        this.entries.remove(entry);
    }

    @NotNull
    public final Quadrant<T> createLargerQuadrant(@NotNull Entry<T> entry) {
        Quadrant<T> quadrant;
        Intrinsics.checkNotNullParameter(entry, (String)"entry");
        double rootWidth = this.maxX - this.minX;
        double rootHeight = this.maxY - this.minY;
        Pair<Double, Double> midEntry = this.calcMid(entry.getMinX(), entry.getMinY(), entry.getMaxX(), entry.getMaxY());
        Pair<Double, Double> midQuadrant = this.calcMid(this.minX, this.minY, this.maxX, this.maxY);
        if (((Number)midEntry.getFirst()).doubleValue() <= ((Number)midQuadrant.getFirst()).doubleValue()) {
            Quadrant<T> quadrant2;
            double minX = this.minX - rootWidth;
            if (((Number)midEntry.getSecond()).doubleValue() <= ((Number)midQuadrant.getSecond()).doubleValue()) {
                Quadrant<T> quadrant3;
                double minY = this.minY - rootHeight;
                Quadrant<T> it = quadrant3 = new Quadrant<T>(minX, minY, this.maxX, this.maxY, this.options);
                boolean bl = false;
                super.splitQuadrant();
                it.bottomRight = this;
                return quadrant3;
            }
            double maxY = this.maxY + rootHeight;
            Quadrant<T> it = quadrant2 = new Quadrant<T>(minX, this.minY, this.maxX, maxY, this.options);
            boolean bl = false;
            super.splitQuadrant();
            it.topRight = this;
            return quadrant2;
        }
        double maxX = this.maxX + rootWidth;
        if (((Number)midEntry.getSecond()).doubleValue() <= ((Number)midQuadrant.getSecond()).doubleValue()) {
            Quadrant<T> quadrant4;
            double minY = this.minY - rootHeight;
            Quadrant<T> it = quadrant4 = new Quadrant<T>(this.minX, minY, maxX, this.maxY, this.options);
            boolean bl = false;
            super.splitQuadrant();
            it.bottomLeft = this;
            return quadrant4;
        }
        double maxY = this.maxY + rootHeight;
        Quadrant<T> it = quadrant = new Quadrant<T>(this.minX, this.minY, maxX, maxY, this.options);
        boolean bl = false;
        super.splitQuadrant();
        it.topLeft = this;
        return quadrant;
    }

    private final Pair<Double, Double> calcMid(double minX, double minY, double maxX, double maxY) {
        double midX = minX / (double)2 + maxX / (double)2;
        double midY = minY / (double)2 + maxY / (double)2;
        return TuplesKt.to((Object)midX, (Object)midY);
    }
}

