/*
 * Decompiled with CFR 0.152.
 */
package com.github.hanseter.quadtree;

import com.github.hanseter.quadtree.QuadtreeOptions;
import com.github.hanseter.quadtree.impl.Entry;
import com.github.hanseter.quadtree.impl.Quadrant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0010\u001e\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u000f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0012\u001a\u00020\u0013J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016J,\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f2\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0016J\u0017\u0010\u001c\u001a\u00020\u00132\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0082\u0010J3\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001fJ\u0013\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\"J\u0014\u0010#\u001a\u00020\u00132\f\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000$R6\u0010\u0006\u001a*\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u0007j\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006%"}, d2={"Lcom/github/hanseter/quadtree/Quadtree;", "T", "", "options", "Lcom/github/hanseter/quadtree/QuadtreeOptions;", "(Lcom/github/hanseter/quadtree/QuadtreeOptions;)V", "entries", "Ljava/util/HashMap;", "Lcom/github/hanseter/quadtree/impl/Entry;", "Lkotlin/collections/HashMap;", "getOptions", "()Lcom/github/hanseter/quadtree/QuadtreeOptions;", "root", "Lcom/github/hanseter/quadtree/impl/Quadrant;", "values", "", "getValues", "()Ljava/util/List;", "clear", "", "find", "x", "", "y", "minX", "minY", "maxX", "maxY", "insert", "entry", "value", "(DDDDLjava/lang/Object;)V", "remove", "toRemove", "(Ljava/lang/Object;)V", "removeAll", "", "quadtree"})
@SourceDebugExtension(value={"SMAP\nQuadtree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Quadtree.kt\ncom/github/hanseter/quadtree/Quadtree\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n1855#2,2:92\n1855#2,2:94\n*S KotlinDebug\n*F\n+ 1 Quadtree.kt\ncom/github/hanseter/quadtree/Quadtree\n*L\n79#1:92,2\n88#1:94,2\n*E\n"})
public final class Quadtree<T> {
    @NotNull
    private final QuadtreeOptions options;
    @NotNull
    private Quadrant<T> root;
    @NotNull
    private final HashMap<T, Entry<T>> entries;

    public Quadtree(@NotNull QuadtreeOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.options = options;
        this.root = new Quadrant(this.options.getInitialX(), this.options.getInitialY(), this.options.getInitialX() + this.options.getInitialSize(), this.options.getInitialY() + this.options.getInitialSize(), this.options);
        this.entries = new HashMap();
    }

    public /* synthetic */ Quadtree(QuadtreeOptions quadtreeOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            quadtreeOptions = new QuadtreeOptions(0, 0.0, 0.0, 0.0, 15, null);
        }
        this(quadtreeOptions);
    }

    @NotNull
    public final QuadtreeOptions getOptions() {
        return this.options;
    }

    @NotNull
    public final List<T> getValues() {
        Set<T> set = this.entries.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        return CollectionsKt.toList((Iterable)set);
    }

    public final void insert(double minX, double minY, double maxX, double maxY, T value) {
        block0: {
            Entry<T> entry = new Entry<T>(minX, minY, maxX, maxY, value);
            this.insert(entry);
            Entry<T> entry2 = this.entries.put(value, entry);
            if (entry2 == null) break block0;
            entry2.remove();
        }
    }

    private final void insert(Entry<T> entry) {
        while (!this_.root.insert(entry)) {
            this_.root = this_.root.createLargerQuadrant(entry);
            Quadtree quadtree = this_;
            Entry<T> entry2 = entry;
            Quadtree this_ = quadtree;
            entry = entry2;
        }
        return;
    }

    @NotNull
    public final List<T> find(double x, double y) {
        ArrayList ret = new ArrayList();
        this.root.find(x, y, ret);
        return ret;
    }

    @NotNull
    public final List<T> find(double minX, double minY, double maxX, double maxY) {
        ArrayList ret = new ArrayList();
        this.root.find(minX, minY, maxX, maxY, ret);
        return ret;
    }

    public final void remove(T toRemove) {
        block0: {
            Entry<T> entry = this.entries.remove(toRemove);
            if (entry == null) break block0;
            entry.remove();
        }
    }

    public final void removeAll(@NotNull Collection<? extends T> toRemove) {
        Intrinsics.checkNotNullParameter(toRemove, (String)"toRemove");
        Iterable $this$forEach$iv = toRemove;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator.next();
            boolean bl = false;
            this.remove(it);
        }
    }

    public final void clear() {
        Collection<Entry<T>> collection = this.entries.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entry it = (Entry)element$iv;
            boolean bl = false;
            it.remove();
        }
        this.entries.clear();
    }

    public Quadtree() {
        this(null, 1, null);
    }
}

