/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl.util;

import java.io.IOException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.altindag.ssl.exception.GenericIOException;
import nl.altindag.ssl.util.CertificateUtils;
import nl.altindag.ssl.util.OperatingSystem;
import nl.altindag.ssl.util.internal.IOUtils;

final class MacCertificateUtils {
    private static final String SECURITY_EXECUTABLE = "security";
    private static final String SYSTEM_ROOT_KEYCHAIN_FILE = "/System/Library/Keychains/SystemRootCertificates.keychain";
    private static final List<String> KEYCHAIN_LOOKUP_COMMANDS = Arrays.asList("list-keychains", "default-keychain");
    private static final String EMPTY = "";
    private static final String SPACE = " ";
    private static final String DOUBLE_QUOTES = "\"";

    private MacCertificateUtils() {
    }

    static List<Certificate> getCertificates() {
        if (OperatingSystem.get() != OperatingSystem.MAC) {
            return Collections.emptyList();
        }
        String certificateContent = MacCertificateUtils.getKeychainFiles().stream().distinct().map(MacCertificateUtils::createProcessForGettingCertificates).map(Process::getInputStream).map(IOUtils::getContent).collect(Collectors.joining(System.lineSeparator()));
        return CertificateUtils.parsePemCertificate(certificateContent);
    }

    static List<String> getKeychainFiles() {
        ArrayList<String> keychainFiles = new ArrayList<String>();
        keychainFiles.add(SYSTEM_ROOT_KEYCHAIN_FILE);
        KEYCHAIN_LOOKUP_COMMANDS.stream().map(MacCertificateUtils::createProcessForGettingKeychainFile).map(Process::getInputStream).map(IOUtils::getContent).flatMap(content -> Stream.of(content.split(System.lineSeparator())).map(line -> line.replace(DOUBLE_QUOTES, EMPTY)).map(String::trim)).filter(keyChainFile -> !keyChainFile.endsWith("login.keychain-db")).forEach(keychainFiles::add);
        return keychainFiles;
    }

    private static Process createProcessForGettingKeychainFile(String command) {
        return MacCertificateUtils.createProcess("security " + command);
    }

    private static Process createProcessForGettingCertificates(String keychainFilePath) {
        String command = String.format("%s find-certificate -a -p %s", SECURITY_EXECUTABLE, keychainFilePath);
        return MacCertificateUtils.createProcess(command);
    }

    private static Process createProcess(String command) {
        try {
            return Runtime.getRuntime().exec(command);
        }
        catch (IOException e) {
            throw new GenericIOException(e);
        }
    }
}

