/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl.trustmanager;

import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import nl.altindag.ssl.trustmanager.HotSwappableX509ExtendedTrustManager;
import nl.altindag.ssl.trustmanager.TrustManagerConsumer;
import nl.altindag.ssl.util.CertificateUtils;
import nl.altindag.ssl.util.KeyStoreUtils;
import nl.altindag.ssl.util.TrustManagerUtils;
import nl.altindag.ssl.util.internal.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InflatableX509ExtendedTrustManager
extends HotSwappableX509ExtendedTrustManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(InflatableX509ExtendedTrustManager.class);
    private final KeyStore trustStore;
    private final Path trustStorePath;
    private final char[] trustStorePassword;
    private final BiPredicate<X509Certificate[], String> certificateAndAuthTypeTrustPredicate;

    public InflatableX509ExtendedTrustManager() {
        this(null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InflatableX509ExtendedTrustManager(Path trustStorePath, char[] trustStorePassword, String trustStoreType, BiPredicate<X509Certificate[], String> certificateAndAuthTypeTrustPredicate) {
        super(TrustManagerUtils.createDummyTrustManager());
        this.writeLock.lock();
        try {
            this.trustStorePath = trustStorePath;
            this.trustStorePassword = trustStorePassword;
            this.certificateAndAuthTypeTrustPredicate = Optional.ofNullable(certificateAndAuthTypeTrustPredicate).orElse((chain, authType) -> false);
            if (trustStorePath != null && StringUtils.isNotBlank(trustStoreType)) {
                if (Files.exists(trustStorePath, new LinkOption[0])) {
                    this.trustStore = KeyStoreUtils.loadKeyStore(trustStorePath, trustStorePassword, trustStoreType);
                    this.setTrustManager(TrustManagerUtils.createTrustManager(this.trustStore));
                } else {
                    this.trustStore = KeyStoreUtils.createKeyStore(trustStoreType, trustStorePassword);
                }
            } else {
                this.trustStore = KeyStoreUtils.createKeyStore();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkTrusted(trustManager -> super.checkServerTrusted(chain, authType), chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.checkTrusted(trustManager -> super.checkServerTrusted(chain, authType, socket), chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        this.checkTrusted(trustManager -> super.checkServerTrusted(chain, authType, sslEngine), chain, authType);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkTrusted(trustManager -> super.checkClientTrusted(chain, authType), chain, authType);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.checkTrusted(trustManager -> super.checkClientTrusted(chain, authType, socket), chain, authType);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        this.checkTrusted(trustManager -> super.checkClientTrusted(chain, authType, sslEngine), chain, authType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTrusted(TrustManagerConsumer trustManagerConsumer, X509Certificate[] chain, String authType) throws CertificateException {
        block11: {
            try {
                this.readLock.lock();
                try {
                    trustManagerConsumer.checkTrusted(this);
                }
                finally {
                    this.readLock.unlock();
                }
            }
            catch (CertificateException e) {
                this.writeLock.lock();
                try {
                    trustManagerConsumer.checkTrusted(this);
                }
                catch (CertificateException e2) {
                    boolean shouldBeTrusted = this.certificateAndAuthTypeTrustPredicate.test(chain, authType);
                    if (shouldBeTrusted) {
                        this.addCertificates(Collections.singletonList(chain[0]));
                        break block11;
                    }
                    throw e2;
                }
                finally {
                    this.writeLock.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCertificates(List<X509Certificate> certificates) {
        this.writeLock.lock();
        try {
            for (Certificate certificate : certificates) {
                String alias = CertificateUtils.generateAlias(certificate);
                this.trustStore.setCertificateEntry(alias, certificate);
                LOGGER.info("Added certificate for [{}]", (Object)alias);
            }
            X509ExtendedTrustManager trustManager = TrustManagerUtils.createTrustManager(this.trustStore);
            this.setTrustManager(trustManager);
            if (this.trustStorePath != null) {
                KeyStoreUtils.write(this.trustStorePath, this.trustStore, this.trustStorePassword);
            }
        }
        catch (KeyStoreException e) {
            LOGGER.error("Cannot add certificate", (Throwable)e);
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

