/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl.trustmanager;

import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import nl.altindag.ssl.trustmanager.DelegatingX509ExtendedTrustManager;
import nl.altindag.ssl.util.internal.ValidationUtils;

public class HotSwappableX509ExtendedTrustManager
extends DelegatingX509ExtendedTrustManager {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    protected final Lock readLock = this.readWriteLock.readLock();
    protected final Lock writeLock = this.readWriteLock.writeLock();

    public HotSwappableX509ExtendedTrustManager(X509ExtendedTrustManager trustManager) {
        super(trustManager);
    }

    public void setTrustManager(X509ExtendedTrustManager trustManager) {
        this.writeLock.lock();
        try {
            this.trustManager = ValidationUtils.requireNotNull(trustManager, (String)ValidationUtils.GENERIC_EXCEPTION_MESSAGE.apply("TrustManager"));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public X509ExtendedTrustManager getInnerTrustManager() {
        this.readLock.lock();
        try {
            X509ExtendedTrustManager x509ExtendedTrustManager = (X509ExtendedTrustManager)super.getInnerTrustManager();
            return x509ExtendedTrustManager;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.readLock.lock();
        try {
            super.checkServerTrusted(chain, authType);
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.readLock.lock();
        try {
            super.checkServerTrusted(chain, authType, socket);
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        this.readLock.lock();
        try {
            super.checkServerTrusted(chain, authType, sslEngine);
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.readLock.lock();
        try {
            super.checkClientTrusted(chain, authType);
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.readLock.lock();
        try {
            super.checkClientTrusted(chain, authType, socket);
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        this.readLock.lock();
        try {
            super.checkClientTrusted(chain, authType, sslEngine);
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        this.readLock.lock();
        try {
            X509Certificate[] x509CertificateArray = super.getAcceptedIssuers();
            return x509CertificateArray;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

