/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl.keymanager;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedKeyManager;

public final class CompositeX509ExtendedKeyManager
extends X509ExtendedKeyManager {
    private static final Predicate<String> NON_NULL = Objects::nonNull;
    private final List<X509ExtendedKeyManager> keyManagers;
    private final Map<String, List<URI>> preferredAliasToHost;

    public CompositeX509ExtendedKeyManager(List<? extends X509ExtendedKeyManager> keyManagers) {
        this(keyManagers, Collections.emptyMap());
    }

    public CompositeX509ExtendedKeyManager(List<? extends X509ExtendedKeyManager> keyManagers, Map<String, List<URI>> preferredAliasToHost) {
        this.keyManagers = Collections.unmodifiableList(keyManagers);
        this.preferredAliasToHost = new HashMap<String, List<URI>>(preferredAliasToHost);
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        return this.chooseClientAlias(socket, aSocket -> aSocket != null && aSocket.getRemoteSocketAddress() instanceof InetSocketAddress, aSocket -> {
            InetSocketAddress socketAddress = (InetSocketAddress)aSocket.getRemoteSocketAddress();
            return new AbstractMap.SimpleImmutableEntry<String, Integer>(socketAddress.getHostName(), socketAddress.getPort());
        }, keyManager -> keyManager.chooseClientAlias(keyType, issuers, socket));
    }

    @Override
    public String chooseEngineClientAlias(String[] keyTypes, Principal[] issuers, SSLEngine sslEngine) {
        return this.chooseClientAlias(sslEngine, Objects::nonNull, aSslEngine -> new AbstractMap.SimpleImmutableEntry<String, Integer>(aSslEngine.getPeerHost(), aSslEngine.getPeerPort()), keyManager -> keyManager.chooseEngineClientAlias(keyTypes, issuers, sslEngine));
    }

    private <T> String chooseClientAlias(T object, Predicate<T> predicate, Function<T, AbstractMap.SimpleImmutableEntry<String, Integer>> hostToPortExtractor, Function<X509ExtendedKeyManager, String> aliasExtractor) {
        return this.getPreferredClientAlias(object, predicate, hostToPortExtractor).map(preferredAlias -> this.extractInnerField(aliasExtractor, NON_NULL.and(preferredAlias::equals))).orElseGet(() -> this.extractInnerField(aliasExtractor, NON_NULL));
    }

    private <T> Optional<String> getPreferredClientAlias(T object, Predicate<T> predicate, Function<T, AbstractMap.SimpleImmutableEntry<String, Integer>> hostToPortExtractor) {
        if (this.preferredAliasToHost.isEmpty()) {
            return Optional.empty();
        }
        if (predicate.test(object)) {
            AbstractMap.SimpleImmutableEntry<String, Integer> hostToPort = hostToPortExtractor.apply(object);
            return this.getPreferredClientAlias(hostToPort.getKey(), hostToPort.getValue());
        }
        return Optional.empty();
    }

    private Optional<String> getPreferredClientAlias(String peerHost, int peerPort) {
        return this.preferredAliasToHost.entrySet().stream().filter(entry -> ((List)entry.getValue()).stream().anyMatch(uri -> uri.getHost().contains(peerHost))).filter(entry -> ((List)entry.getValue()).stream().anyMatch(uri -> uri.getPort() == peerPort)).findFirst().map(Map.Entry::getKey);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.chooseServerAlias(socket, SSLSocket.class::isInstance, aSocket -> ((SSLSocket)aSocket).getHandshakeSession(), keyManager -> keyManager.chooseServerAlias(keyType, issuers, socket));
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine sslEngine) {
        return this.chooseServerAlias(sslEngine, Objects::nonNull, SSLEngine::getHandshakeSession, keyManager -> keyManager.chooseEngineServerAlias(keyType, issuers, sslEngine));
    }

    private <T> String chooseServerAlias(T object, Predicate<T> predicate, Function<T, SSLSession> sslSessionExtractor, Function<X509ExtendedKeyManager, String> aliasExtractor) {
        return this.getPreferredServerAlias(object, predicate, sslSessionExtractor).map(preferredAlias -> this.extractInnerField(aliasExtractor, NON_NULL.and(preferredAlias::equals))).orElseGet(() -> this.extractInnerField(aliasExtractor, NON_NULL));
    }

    private <T> Optional<String> getPreferredServerAlias(T object, Predicate<T> predicate, Function<T, SSLSession> sslSessionExtractor) {
        SSLSession sslSession;
        if (this.preferredAliasToHost.isEmpty()) {
            return Optional.empty();
        }
        if (predicate.test(object) && (sslSession = sslSessionExtractor.apply(object)) instanceof ExtendedSSLSession) {
            List<SNIServerName> requestedServerNames = ((ExtendedSSLSession)sslSession).getRequestedServerNames();
            Set<String> hostnames = requestedServerNames.stream().map(sniServerName -> new String(sniServerName.getEncoded())).collect(Collectors.toSet());
            return this.getPreferredServerAlias(hostnames);
        }
        return Optional.empty();
    }

    private Optional<String> getPreferredServerAlias(Set<String> hostnames) {
        return this.preferredAliasToHost.entrySet().stream().filter(entry -> ((List)entry.getValue()).stream().anyMatch(uri -> hostnames.stream().anyMatch(hostname -> uri.getHost().contains((CharSequence)hostname)))).findFirst().map(Map.Entry::getKey);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.extractInnerField(keyManager -> keyManager.getPrivateKey(alias), Objects::nonNull);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        return this.extractInnerField(keyManager -> keyManager.getCertificateChain(alias), chain -> chain != null && ((X509Certificate[])chain).length > 0);
    }

    private <T> T extractInnerField(Function<X509ExtendedKeyManager, T> keyManagerMapper, Predicate<T> predicate) {
        return this.keyManagers.stream().map(keyManagerMapper).filter(predicate).findFirst().orElse(null);
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.getAliases(keyManager -> keyManager.getClientAliases(keyType, issuers));
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.getAliases(keyManager -> keyManager.getServerAliases(keyType, issuers));
    }

    private String[] getAliases(Function<X509ExtendedKeyManager, String[]> aliasExtractor) {
        return this.keyManagers.stream().map(aliasExtractor).filter(Objects::nonNull).flatMap(Arrays::stream).collect(Collectors.collectingAndThen(Collectors.toList(), this::emptyToNull));
    }

    private String[] emptyToNull(List<String> list) {
        return list.isEmpty() ? null : list.toArray(new String[0]);
    }

    public int size() {
        return this.keyManagers.size();
    }

    public List<X509ExtendedKeyManager> getKeyManagers() {
        return this.keyManagers;
    }

    @Deprecated
    public Map<String, List<URI>> getPreferredClientAliasToHosts() {
        return this.preferredAliasToHost;
    }

    public Map<String, List<URI>> getPreferredAliasToHosts() {
        return this.preferredAliasToHost;
    }
}

