/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl.keymanager;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;

public final class CompositeX509ExtendedKeyManager
extends X509ExtendedKeyManager {
    private static final Predicate<String> NON_NULL = Objects::nonNull;
    private final List<X509ExtendedKeyManager> keyManagers;
    private final Map<String, List<URI>> preferredClientAliasToHost;

    public CompositeX509ExtendedKeyManager(List<? extends X509ExtendedKeyManager> keyManagers) {
        this(keyManagers, Collections.emptyMap());
    }

    public CompositeX509ExtendedKeyManager(List<? extends X509ExtendedKeyManager> keyManagers, Map<String, List<URI>> preferredClientAliasToHost) {
        this.keyManagers = Collections.unmodifiableList(keyManagers);
        this.preferredClientAliasToHost = new HashMap<String, List<URI>>(preferredClientAliasToHost);
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        Optional<String> preferredAlias = this.getPreferredClientAlias(socket);
        if (preferredAlias.isPresent()) {
            return this.extractInnerField(keyManager -> keyManager.chooseClientAlias(keyType, issuers, socket), NON_NULL.and(alias -> ((String)preferredAlias.get()).equals(alias)));
        }
        return this.extractInnerField(keyManager -> keyManager.chooseClientAlias(keyType, issuers, socket), NON_NULL);
    }

    @Override
    public String chooseEngineClientAlias(String[] keyTypes, Principal[] issuers, SSLEngine sslEngine) {
        Optional<String> preferredAlias = this.getPreferredClientAlias(sslEngine);
        if (preferredAlias.isPresent()) {
            return this.extractInnerField(keyManager -> keyManager.chooseEngineClientAlias(keyTypes, issuers, sslEngine), NON_NULL.and(alias -> ((String)preferredAlias.get()).equals(alias)));
        }
        return this.extractInnerField(keyManager -> keyManager.chooseEngineClientAlias(keyTypes, issuers, sslEngine), NON_NULL);
    }

    private Optional<String> getPreferredClientAlias(Socket socket) {
        if (!this.preferredClientAliasToHost.isEmpty() && socket != null && socket.getRemoteSocketAddress() instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)socket.getRemoteSocketAddress();
            return this.getPreferredClientAlias(address.getHostName(), address.getPort());
        }
        return Optional.empty();
    }

    private Optional<String> getPreferredClientAlias(SSLEngine sslEngine) {
        if (!this.preferredClientAliasToHost.isEmpty() && sslEngine != null) {
            return this.getPreferredClientAlias(sslEngine.getPeerHost(), sslEngine.getPeerPort());
        }
        return Optional.empty();
    }

    private Optional<String> getPreferredClientAlias(String peerHost, int peerPort) {
        return this.preferredClientAliasToHost.entrySet().stream().filter(entry -> ((List)entry.getValue()).stream().anyMatch(uri -> uri.getHost().equals(peerHost))).filter(entry -> ((List)entry.getValue()).stream().anyMatch(uri -> uri.getPort() == peerPort)).findFirst().map(Map.Entry::getKey);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.extractInnerField(keyManager -> keyManager.chooseServerAlias(keyType, issuers, socket), Objects::nonNull);
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine sslEngine) {
        return this.extractInnerField(keyManager -> keyManager.chooseEngineServerAlias(keyType, issuers, sslEngine), Objects::nonNull);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.extractInnerField(keyManager -> keyManager.getPrivateKey(alias), Objects::nonNull);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        return this.extractInnerField(keyManager -> keyManager.getCertificateChain(alias), chain -> chain != null && ((X509Certificate[])chain).length > 0);
    }

    private <T> T extractInnerField(Function<X509ExtendedKeyManager, T> keyManagerMapper, Predicate<T> predicate) {
        return this.keyManagers.stream().map(keyManagerMapper).filter(predicate).findFirst().orElse(null);
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.getAliases(keyManager -> keyManager.getClientAliases(keyType, issuers));
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.getAliases(keyManager -> keyManager.getServerAliases(keyType, issuers));
    }

    private String[] getAliases(Function<X509ExtendedKeyManager, String[]> aliasExtractor) {
        return this.keyManagers.stream().map(aliasExtractor).filter(Objects::nonNull).flatMap(Arrays::stream).collect(Collectors.collectingAndThen(Collectors.toList(), this::emptyToNull));
    }

    private String[] emptyToNull(List<String> list) {
        return list.isEmpty() ? null : list.toArray(new String[0]);
    }

    public int size() {
        return this.keyManagers.size();
    }

    public List<X509ExtendedKeyManager> getKeyManagers() {
        return this.keyManagers;
    }

    public Map<String, List<URI>> getPreferredClientAliasToHosts() {
        return this.preferredClientAliasToHost;
    }
}

