/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl.util;

import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public final class ValidationUtils {
    public static final UnaryOperator<String> GENERIC_EXCEPTION_MESSAGE = objectType -> String.format("No valid %s has been provided. %s must be present, but was absent.", objectType, objectType);

    private ValidationUtils() {
    }

    public static <T> T requireNotNull(T maybeNull) {
        return ValidationUtils.requireNotNull(maybeNull, () -> new IllegalArgumentException((String)GENERIC_EXCEPTION_MESSAGE.apply(maybeNull.getClass().getSimpleName())));
    }

    public static <T> T requireNotNull(T maybeNull, String message) {
        return ValidationUtils.requireNotNull(maybeNull, () -> new IllegalArgumentException(message));
    }

    public static <T> T requireNotNull(T maybeNull, Supplier<RuntimeException> exceptionSupplier) {
        if (maybeNull == null) {
            throw exceptionSupplier.get();
        }
        return maybeNull;
    }
}

