/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl.trustmanager;

import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompositeX509ExtendedTrustManager
extends X509ExtendedTrustManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeX509ExtendedTrustManager.class);
    private static final String CERTIFICATE_EXCEPTION_MESSAGE = "None of the TrustManagers trust this certificate chain";
    private static final String CLIENT_CERTIFICATE_LOG_MESSAGE = "Received the following client certificate: [{}]";
    private static final String SERVER_CERTIFICATE_LOG_MESSAGE = "Received the following server certificate: [{}]";
    private final List<X509ExtendedTrustManager> trustManagers;
    private final X509Certificate[] acceptedIssuers;

    public CompositeX509ExtendedTrustManager(List<? extends X509ExtendedTrustManager> trustManagers) {
        this.trustManagers = Collections.unmodifiableList(trustManagers);
        this.acceptedIssuers = (X509Certificate[])this.trustManagers.stream().map(X509TrustManager::getAcceptedIssuers).flatMap(Arrays::stream).distinct().toArray(X509Certificate[]::new);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        CompositeX509ExtendedTrustManager.logCertificate(CLIENT_CERTIFICATE_LOG_MESSAGE, chain);
        this.checkTrusted(trustManager -> trustManager.checkClientTrusted(chain, authType));
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        CompositeX509ExtendedTrustManager.logCertificate(CLIENT_CERTIFICATE_LOG_MESSAGE, chain);
        this.checkTrusted(trustManager -> trustManager.checkClientTrusted(chain, authType, socket));
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        CompositeX509ExtendedTrustManager.logCertificate(CLIENT_CERTIFICATE_LOG_MESSAGE, chain);
        this.checkTrusted(trustManager -> trustManager.checkClientTrusted(chain, authType, sslEngine));
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        CompositeX509ExtendedTrustManager.logCertificate(SERVER_CERTIFICATE_LOG_MESSAGE, chain);
        this.checkTrusted(trustManager -> trustManager.checkServerTrusted(chain, authType));
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        CompositeX509ExtendedTrustManager.logCertificate(SERVER_CERTIFICATE_LOG_MESSAGE, chain);
        this.checkTrusted(trustManager -> trustManager.checkServerTrusted(chain, authType, socket));
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        CompositeX509ExtendedTrustManager.logCertificate(SERVER_CERTIFICATE_LOG_MESSAGE, chain);
        this.checkTrusted(trustManager -> trustManager.checkServerTrusted(chain, authType, sslEngine));
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return Arrays.copyOf(this.acceptedIssuers, this.acceptedIssuers.length);
    }

    public int size() {
        return this.trustManagers.size();
    }

    public List<X509ExtendedTrustManager> getTrustManagers() {
        return this.trustManagers;
    }

    private void checkTrusted(TrustManagerConsumer callBackConsumer) throws CertificateException {
        ArrayList<CertificateException> certificateExceptions = new ArrayList<CertificateException>();
        for (X509ExtendedTrustManager trustManager : this.trustManagers) {
            try {
                callBackConsumer.checkTrusted(trustManager);
                return;
            }
            catch (CertificateException e) {
                certificateExceptions.add(e);
            }
        }
        CertificateException certificateException = new CertificateException(CERTIFICATE_EXCEPTION_MESSAGE);
        certificateExceptions.forEach(certificateException::addSuppressed);
        throw certificateException;
    }

    private static void logCertificate(String messageTemplate, X509Certificate[] chain) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(messageTemplate, (Object)chain[0].getSubjectDN());
        }
    }

    @FunctionalInterface
    private static interface TrustManagerConsumer {
        public void checkTrusted(X509ExtendedTrustManager var1) throws CertificateException;
    }
}

