/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl.util;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import nl.altindag.ssl.exception.GenericSSLContextException;
import nl.altindag.ssl.util.KeyManagerUtils;
import nl.altindag.ssl.util.TrustManagerUtils;

public final class SSLContextUtils {
    private static final String DEFAULT_SSL_CONTEXT_PROTOCOL = "TLS";

    private SSLContextUtils() {
    }

    public static SSLContext createSslContext(List<? extends X509KeyManager> keyManagers, List<? extends X509TrustManager> trustManagers) {
        return SSLContextUtils.createSslContext(keyManagers, trustManagers, null);
    }

    public static SSLContext createSslContext(List<? extends X509KeyManager> keyManagers, List<? extends X509TrustManager> trustManagers, SecureRandom secureRandom) {
        return SSLContextUtils.createSslContext(keyManagers, trustManagers, secureRandom, DEFAULT_SSL_CONTEXT_PROTOCOL, (Provider)null);
    }

    public static SSLContext createSslContext(List<? extends X509KeyManager> keyManagers, List<? extends X509TrustManager> trustManagers, SecureRandom secureRandom, String sslContextProtocol, Provider securityProvider) {
        return SSLContextUtils.createSslContext(!keyManagers.isEmpty() ? KeyManagerUtils.combine(keyManagers) : null, !trustManagers.isEmpty() ? TrustManagerUtils.combine(trustManagers) : null, secureRandom, sslContextProtocol, null, securityProvider);
    }

    public static SSLContext createSslContext(List<? extends X509KeyManager> keyManagers, List<? extends X509TrustManager> trustManagers, SecureRandom secureRandom, String sslContextProtocol, String securityProviderName) {
        return SSLContextUtils.createSslContext(!keyManagers.isEmpty() ? KeyManagerUtils.combine(keyManagers) : null, !trustManagers.isEmpty() ? TrustManagerUtils.combine(trustManagers) : null, secureRandom, sslContextProtocol, securityProviderName, null);
    }

    public static SSLContext createSslContext(X509KeyManager keyManager, X509TrustManager trustManager, SecureRandom secureRandom, String sslContextProtocol, String securityProviderName, Provider securityProvider) {
        return SSLContextUtils.createSslContext(keyManager != null ? KeyManagerUtils.toArray(keyManager) : null, trustManager != null ? TrustManagerUtils.toArray(trustManager) : null, secureRandom, sslContextProtocol, securityProviderName, securityProvider);
    }

    private static SSLContext createSslContext(X509KeyManager[] keyManagers, X509TrustManager[] trustManagers, SecureRandom secureRandom, String sslContextProtocol, String securityProviderName, Provider securityProvider) {
        try {
            SSLContext sslContext = Objects.nonNull(securityProvider) ? SSLContext.getInstance(sslContextProtocol, securityProvider) : (Objects.nonNull(securityProviderName) ? SSLContext.getInstance(sslContextProtocol, securityProviderName) : SSLContext.getInstance(sslContextProtocol));
            sslContext.init(keyManagers, trustManagers, secureRandom);
            return sslContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new GenericSSLContextException(e);
        }
    }
}

