/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.sslcontext.util;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import nl.altindag.sslcontext.exception.GenericSecurityException;
import nl.altindag.sslcontext.model.KeyStoreHolder;
import nl.altindag.sslcontext.trustmanager.CompositeX509ExtendedTrustManager;
import nl.altindag.sslcontext.trustmanager.X509TrustManagerWrapper;
import nl.altindag.sslcontext.util.KeyStoreUtils;

public final class TrustManagerUtils {
    private TrustManagerUtils() {
    }

    public static X509ExtendedTrustManager combine(X509ExtendedTrustManager ... trustManagers) {
        return TrustManagerUtils.combine(Arrays.asList(trustManagers));
    }

    public static X509ExtendedTrustManager combine(List<? extends X509ExtendedTrustManager> trustManagers) {
        if (trustManagers.size() == 1) {
            return trustManagers.get(0);
        }
        return CompositeX509ExtendedTrustManager.builder().withTrustManagers(trustManagers).build();
    }

    public static X509ExtendedTrustManager createTrustManagerWithJdkTrustedCertificates() {
        return TrustManagerUtils.createTrustManager((KeyStore)null);
    }

    public static X509ExtendedTrustManager createTrustManagerWithSystemTrustedCertificates() {
        try {
            KeyStore[] trustStores = KeyStoreUtils.loadSystemKeyStores().toArray(new KeyStore[0]);
            return TrustManagerUtils.createTrustManager(trustStores);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new GenericSecurityException(e);
        }
    }

    public static X509ExtendedTrustManager createTrustManager(KeyStoreHolder ... trustStoreHolders) {
        return Arrays.stream(trustStoreHolders).map(KeyStoreHolder::getKeyStore).map(TrustManagerUtils::createTrustManager).collect(Collectors.collectingAndThen(Collectors.toList(), TrustManagerUtils::combine));
    }

    public static X509ExtendedTrustManager createTrustManager(KeyStore ... trustStores) {
        return Arrays.stream(trustStores).map(TrustManagerUtils::createTrustManager).collect(Collectors.collectingAndThen(Collectors.toList(), TrustManagerUtils::combine));
    }

    public static X509ExtendedTrustManager createTrustManager(KeyStore trustStore) {
        return TrustManagerUtils.createTrustManager(trustStore, TrustManagerFactory.getDefaultAlgorithm());
    }

    public static X509ExtendedTrustManager createTrustManager(KeyStore trustStore, String trustManagerFactoryAlgorithm) {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(trustManagerFactoryAlgorithm);
            return TrustManagerUtils.createTrustManager(trustStore, trustManagerFactory);
        }
        catch (NoSuchAlgorithmException e) {
            throw new GenericSecurityException(e);
        }
    }

    public static X509ExtendedTrustManager createTrustManager(KeyStore trustStore, String trustManagerFactoryAlgorithm, String securityProviderName) {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(trustManagerFactoryAlgorithm, securityProviderName);
            return TrustManagerUtils.createTrustManager(trustStore, trustManagerFactory);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new GenericSecurityException(e);
        }
    }

    public static X509ExtendedTrustManager createTrustManager(KeyStore trustStore, String trustManagerFactoryAlgorithm, Provider securityProvider) {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(trustManagerFactoryAlgorithm, securityProvider);
            return TrustManagerUtils.createTrustManager(trustStore, trustManagerFactory);
        }
        catch (NoSuchAlgorithmException e) {
            throw new GenericSecurityException(e);
        }
    }

    public static X509ExtendedTrustManager createTrustManager(KeyStore trustStore, TrustManagerFactory trustManagerFactory) {
        try {
            trustManagerFactory.init(trustStore);
            return Arrays.stream(trustManagerFactory.getTrustManagers()).filter(trustManager -> trustManager instanceof X509TrustManager).map(trustManager -> (X509TrustManager)trustManager).map(TrustManagerUtils::wrapIfNeeded).collect(Collectors.collectingAndThen(Collectors.toList(), TrustManagerUtils::combine));
        }
        catch (KeyStoreException e) {
            throw new GenericSecurityException(e);
        }
    }

    public static X509ExtendedTrustManager wrapIfNeeded(X509TrustManager trustManager) {
        if (trustManager instanceof X509ExtendedTrustManager) {
            return (X509ExtendedTrustManager)trustManager;
        }
        return new X509TrustManagerWrapper(trustManager);
    }
}

