/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.sslcontext.keymanager;

import java.net.Socket;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import nl.altindag.sslcontext.model.KeyStoreHolder;
import nl.altindag.sslcontext.util.KeyManagerUtils;

public final class CompositeX509ExtendedKeyManager
extends X509ExtendedKeyManager {
    private final List<? extends X509KeyManager> keyManagers;

    public CompositeX509ExtendedKeyManager(List<? extends X509KeyManager> keyManagers) {
        this.keyManagers = Collections.unmodifiableList(keyManagers);
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        for (X509KeyManager x509KeyManager : this.keyManagers) {
            String alias = x509KeyManager.chooseClientAlias(keyType, issuers, socket);
            if (alias == null) continue;
            return alias;
        }
        return null;
    }

    @Override
    public String chooseEngineClientAlias(String[] keyTypes, Principal[] issuers, SSLEngine sslEngine) {
        for (X509KeyManager x509KeyManager : this.keyManagers) {
            String alias;
            if (!(x509KeyManager instanceof X509ExtendedKeyManager) || (alias = ((X509ExtendedKeyManager)x509KeyManager).chooseEngineClientAlias(keyTypes, issuers, sslEngine)) == null) continue;
            return alias;
        }
        return null;
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        for (X509KeyManager x509KeyManager : this.keyManagers) {
            String alias = x509KeyManager.chooseServerAlias(keyType, issuers, socket);
            if (alias == null) continue;
            return alias;
        }
        return null;
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine sslEngine) {
        for (X509KeyManager x509KeyManager : this.keyManagers) {
            String alias;
            if (!(x509KeyManager instanceof X509ExtendedKeyManager) || (alias = ((X509ExtendedKeyManager)x509KeyManager).chooseEngineServerAlias(keyType, issuers, sslEngine)) == null) continue;
            return alias;
        }
        return null;
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        for (X509KeyManager x509KeyManager : this.keyManagers) {
            PrivateKey privateKey = x509KeyManager.getPrivateKey(alias);
            if (privateKey == null) continue;
            return privateKey;
        }
        return null;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        for (X509KeyManager x509KeyManager : this.keyManagers) {
            X509Certificate[] chain = x509KeyManager.getCertificateChain(alias);
            if (chain == null || chain.length <= 0) continue;
            return chain;
        }
        return null;
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        ArrayList<String> aliases = new ArrayList<String>();
        for (X509KeyManager x509KeyManager : this.keyManagers) {
            aliases.addAll(Arrays.asList(x509KeyManager.getClientAliases(keyType, issuers)));
        }
        return this.emptyToNull(aliases.toArray(new String[0]));
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        ArrayList<String> aliases = new ArrayList<String>();
        for (X509KeyManager x509KeyManager : this.keyManagers) {
            aliases.addAll(Arrays.asList(x509KeyManager.getServerAliases(keyType, issuers)));
        }
        return this.emptyToNull(aliases.toArray(new String[0]));
    }

    public int size() {
        return this.keyManagers.size();
    }

    private <T> T[] emptyToNull(T[] arr) {
        return arr.length == 0 ? null : arr;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final List<X509KeyManager> keyManagers = new ArrayList<X509KeyManager>();

        public <T extends X509KeyManager> Builder withKeyManagers(T ... keyManagers) {
            return this.withKeyManagers(Arrays.asList(keyManagers));
        }

        public Builder withKeyManagers(List<? extends X509KeyManager> keyManagers) {
            this.keyManagers.addAll(keyManagers);
            return this;
        }

        public <T extends KeyStoreHolder> Builder withIdentities(T ... identities) {
            return this.withIdentities(Arrays.asList(identities));
        }

        public Builder withIdentities(List<? extends KeyStoreHolder> identities) {
            for (KeyStoreHolder keyStoreHolder : identities) {
                this.keyManagers.add(KeyManagerUtils.createKeyManager(keyStoreHolder.getKeyStore(), keyStoreHolder.getKeyStorePassword()));
            }
            return this;
        }

        public <T extends KeyStore> Builder withIdentity(T identity, char[] identityPassword, String keyManagerAlgorithm) {
            this.keyManagers.add(KeyManagerUtils.createKeyManager(identity, identityPassword, keyManagerAlgorithm));
            return this;
        }

        public CompositeX509ExtendedKeyManager build() {
            return new CompositeX509ExtendedKeyManager(this.keyManagers);
        }
    }
}

