/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.sslcontext.util;

import java.util.Objects;
import nl.altindag.sslcontext.SSLFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public final class JettySslContextUtils {
    private JettySslContextUtils() {
    }

    public static SslContextFactory.Client forClient(SSLFactory sslFactory) {
        return JettySslContextUtils.createSslContextFactory(sslFactory, new SslContextFactory.Client());
    }

    public static SslContextFactory.Server forServer(SSLFactory sslFactory) {
        return JettySslContextUtils.createSslContextFactory(sslFactory, new SslContextFactory.Server());
    }

    private static <T extends SslContextFactory> T createSslContextFactory(SSLFactory sslFactory, T sslContextFactory) {
        Objects.requireNonNull(sslFactory.getSslContext());
        sslContextFactory.setSslContext(sslFactory.getSslContext());
        sslContextFactory.setIncludeProtocols(sslFactory.getSslContext().getDefaultSSLParameters().getProtocols());
        sslContextFactory.setIncludeCipherSuites(sslFactory.getSslContext().getDefaultSSLParameters().getCipherSuites());
        sslContextFactory.setHostnameVerifier(sslFactory.getHostnameVerifier());
        return sslContextFactory;
    }
}

