/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.sslcontext.keymanager;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import javax.net.ssl.X509KeyManager;
import nl.altindag.sslcontext.model.KeyStoreHolder;
import nl.altindag.sslcontext.util.KeyManagerUtils;

public class CompositeX509KeyManager
implements X509KeyManager {
    private final List<X509KeyManager> keyManagers;

    public CompositeX509KeyManager(List<? extends X509KeyManager> keyManagers) {
        this.keyManagers = ImmutableList.copyOf(keyManagers);
    }

    @Override
    @Nullable
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        for (X509KeyManager keyManager : this.keyManagers) {
            String alias = keyManager.chooseClientAlias(keyType, issuers, socket);
            if (alias == null) continue;
            return alias;
        }
        return null;
    }

    @Override
    @Nullable
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        for (X509KeyManager keyManager : this.keyManagers) {
            String alias = keyManager.chooseServerAlias(keyType, issuers, socket);
            if (alias == null) continue;
            return alias;
        }
        return null;
    }

    @Override
    @Nullable
    public PrivateKey getPrivateKey(String alias) {
        for (X509KeyManager keyManager : this.keyManagers) {
            PrivateKey privateKey = keyManager.getPrivateKey(alias);
            if (privateKey == null) continue;
            return privateKey;
        }
        return null;
    }

    @Override
    @Nullable
    public X509Certificate[] getCertificateChain(String alias) {
        for (X509KeyManager keyManager : this.keyManagers) {
            X509Certificate[] chain = keyManager.getCertificateChain(alias);
            if (chain == null || chain.length <= 0) continue;
            return chain;
        }
        return null;
    }

    @Override
    @Nullable
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        ImmutableList.Builder aliases = ImmutableList.builder();
        for (X509KeyManager keyManager : this.keyManagers) {
            aliases.add((Object[])keyManager.getClientAliases(keyType, issuers));
        }
        return this.emptyToNull((String[])Iterables.toArray((Iterable)aliases.build(), String.class));
    }

    @Override
    @Nullable
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        ImmutableList.Builder aliases = ImmutableList.builder();
        for (X509KeyManager keyManager : this.keyManagers) {
            aliases.add((Object[])keyManager.getServerAliases(keyType, issuers));
        }
        return this.emptyToNull((String[])Iterables.toArray((Iterable)aliases.build(), String.class));
    }

    @Nullable
    private <T> T[] emptyToNull(T[] arr) {
        return arr.length == 0 ? null : arr;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<X509KeyManager> keyManagers = new ArrayList<X509KeyManager>();

        public <T extends X509KeyManager> Builder withKeyManagers(T ... keyManagers) {
            return this.withKeyManagers(Arrays.asList(keyManagers));
        }

        public Builder withKeyManagers(List<? extends X509KeyManager> keyManagers) {
            this.keyManagers.addAll(keyManagers);
            return this;
        }

        public <T extends KeyStoreHolder> Builder withIdentities(T ... identities) {
            return this.withIdentities(Arrays.asList(identities));
        }

        public Builder withIdentities(List<? extends KeyStoreHolder> identities) {
            for (KeyStoreHolder keyStoreHolder : identities) {
                this.keyManagers.add(KeyManagerUtils.createKeyManager(keyStoreHolder.getKeyStore(), keyStoreHolder.getKeyStorePassword()));
            }
            return this;
        }

        public <T extends KeyStore> Builder withIdentity(T identity, char[] identityPassword, String keyManagerAlgorithm) {
            this.keyManagers.add(KeyManagerUtils.createKeyManager(identity, identityPassword, keyManagerAlgorithm));
            return this;
        }

        public CompositeX509KeyManager build() {
            return new CompositeX509KeyManager(this.keyManagers);
        }
    }
}

