/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.sslcontext;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import nl.altindag.sslcontext.exception.GenericKeyStoreException;
import nl.altindag.sslcontext.exception.GenericSSLContextException;
import nl.altindag.sslcontext.keymanager.CompositeX509KeyManager;
import nl.altindag.sslcontext.keymanager.KeyManagerFactoryWrapper;
import nl.altindag.sslcontext.model.KeyStoreHolder;
import nl.altindag.sslcontext.trustmanager.CompositeX509TrustManager;
import nl.altindag.sslcontext.trustmanager.TrustManagerFactoryWrapper;
import nl.altindag.sslcontext.trustmanager.UnsafeTrustManager;
import nl.altindag.sslcontext.util.KeystoreUtils;
import nl.altindag.sslcontext.util.TrustManagerUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SSLFactory {
    private static final Logger LOGGER = LogManager.getLogger(SSLFactory.class);
    private final List<KeyStoreHolder> identities = new ArrayList<KeyStoreHolder>();
    private final List<KeyStoreHolder> trustStores = new ArrayList<KeyStoreHolder>();
    private boolean securityEnabled;
    private boolean oneWayAuthenticationEnabled;
    private boolean twoWayAuthenticationEnabled;
    private boolean includeDefaultJdkTrustStore;
    private boolean trustingAllCertificatesWithoutValidationEnabled;
    private String protocol;
    private SSLContext sslContext;
    private CompositeX509TrustManager trustManager;
    private TrustManagerFactory trustManagerFactory;
    private CompositeX509KeyManager keyManager;
    private KeyManagerFactory keyManagerFactory;
    private HostnameVerifier hostnameVerifier;

    private SSLFactory() {
    }

    private void createSSLContextWithTrustStore() {
        try {
            this.createSSLContext(null, this.createTrustManagerFactory().getTrustManagers());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new GenericSSLContextException(e);
        }
    }

    private void createSSLContextWithKeyStoreAndTrustStore() {
        try {
            this.createSSLContext(this.createKeyManagerFactory().getKeyManagers(), this.createTrustManagerFactory().getTrustManagers());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new GenericSSLContextException(e);
        }
    }

    private void createSSLContext(KeyManager[] keyManagers, TrustManager[] trustManagers) throws NoSuchAlgorithmException, KeyManagementException {
        this.sslContext = SSLContext.getInstance(this.protocol);
        this.sslContext.init(keyManagers, trustManagers, null);
    }

    private KeyManagerFactory createKeyManagerFactory() {
        this.keyManager = CompositeX509KeyManager.builder().withIdentities(this.identities).build();
        this.keyManagerFactory = new KeyManagerFactoryWrapper(this.keyManager);
        return this.keyManagerFactory;
    }

    private TrustManagerFactory createTrustManagerFactory() {
        CompositeX509TrustManager.Builder trustManagerBuilder = CompositeX509TrustManager.builder();
        if (this.trustingAllCertificatesWithoutValidationEnabled) {
            LOGGER.warn("UnsafeTrustManager is being used. Client/Server certificates will be accepted without validation. Please don't use this configuration at production.");
            trustManagerBuilder.withTrustManagers(new UnsafeTrustManager[]{UnsafeTrustManager.INSTANCE});
        }
        if (this.includeDefaultJdkTrustStore) {
            trustManagerBuilder.withTrustManagers(new X509TrustManager[]{TrustManagerUtils.createTrustManagerWithJdkTrustedCertificates()});
        }
        this.trustStores.forEach(trustStoreHolder -> trustManagerBuilder.withTrustStore(trustStoreHolder.getKeyStore(), TrustManagerFactory.getDefaultAlgorithm()));
        this.trustManager = trustManagerBuilder.build();
        this.trustManagerFactory = new TrustManagerFactoryWrapper(this.trustManager);
        return this.trustManagerFactory;
    }

    public List<KeyStoreHolder> getIdentities() {
        return ImmutableList.copyOf(this.identities);
    }

    public List<KeyStoreHolder> getTrustStores() {
        return ImmutableList.copyOf(this.trustStores);
    }

    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    public boolean isOneWayAuthenticationEnabled() {
        return this.oneWayAuthenticationEnabled;
    }

    public boolean isTwoWayAuthenticationEnabled() {
        return this.twoWayAuthenticationEnabled;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public X509KeyManager getKeyManager() {
        return this.keyManager;
    }

    public KeyManagerFactory getKeyManagerFactory() {
        return this.keyManagerFactory;
    }

    public X509TrustManager getTrustManager() {
        return this.trustManager;
    }

    public TrustManagerFactory getTrustManagerFactory() {
        return this.trustManagerFactory;
    }

    public X509Certificate[] getTrustedCertificates() {
        return Optional.ofNullable(this.trustManager).map(X509TrustManager::getAcceptedIssuers).orElse(new X509Certificate[0]);
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private static final String TRUST_STORE_VALIDATION_EXCEPTION_MESSAGE = "TrustStore details are empty, which are required to be present when SSL/TLS is enabled";
        private static final String TRUST_STRATEGY_VALIDATION_EXCEPTION_MESSAGE = "Trust strategy is missing. Please validate if the TrustStore is present, or including default JDK trustStore is enabled or trusting all certificates without validation is enabled";
        private static final String IDENTITY_VALIDATION_EXCEPTION_MESSAGE = "Identity details are empty, which are required to be present when SSL/TLS is enabled";
        private static final String KEY_STORE_LOADING_EXCEPTION = "Failed to load the keystore";
        private String protocol = "TLSv1.2";
        private boolean hostnameVerifierEnabled = true;
        private final List<KeyStoreHolder> identities = new ArrayList<KeyStoreHolder>();
        private final List<KeyStoreHolder> trustStores = new ArrayList<KeyStoreHolder>();
        private boolean oneWayAuthenticationEnabled;
        private boolean twoWayAuthenticationEnabled;
        private boolean includeDefaultJdkTrustStore = false;
        private boolean trustingAllCertificatesWithoutValidationEnabled = false;

        private Builder() {
        }

        public Builder withDefaultJdkTrustStore() {
            this.includeDefaultJdkTrustStore = true;
            this.oneWayAuthenticationEnabled = true;
            return this;
        }

        public Builder withTrustStore(String trustStorePath, char[] trustStorePassword) {
            return this.withTrustStore(trustStorePath, trustStorePassword, KeyStore.getDefaultType());
        }

        public Builder withTrustStore(String trustStorePath, char[] trustStorePassword, String trustStoreType) {
            if (StringUtils.isBlank((CharSequence)trustStorePath) || ArrayUtils.isEmpty((char[])trustStorePassword)) {
                throw new GenericKeyStoreException(TRUST_STORE_VALIDATION_EXCEPTION_MESSAGE);
            }
            try {
                KeyStore trustStore = KeystoreUtils.loadKeyStore(trustStorePath, trustStorePassword, trustStoreType);
                KeyStoreHolder trustStoreHolder = new KeyStoreHolder(trustStore, trustStorePassword);
                this.trustStores.add(trustStoreHolder);
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new GenericKeyStoreException(KEY_STORE_LOADING_EXCEPTION, e);
            }
            this.oneWayAuthenticationEnabled = true;
            return this;
        }

        public Builder withTrustStore(Path trustStorePath, char[] trustStorePassword) {
            return this.withTrustStore(trustStorePath, trustStorePassword, KeyStore.getDefaultType());
        }

        public Builder withTrustStore(Path trustStorePath, char[] trustStorePassword, String trustStoreType) {
            if (Objects.isNull(trustStorePath) || ArrayUtils.isEmpty((char[])trustStorePassword) || StringUtils.isBlank((CharSequence)trustStoreType)) {
                throw new GenericKeyStoreException(TRUST_STORE_VALIDATION_EXCEPTION_MESSAGE);
            }
            try {
                KeyStore trustStore = KeystoreUtils.loadKeyStore(trustStorePath, trustStorePassword, trustStoreType);
                KeyStoreHolder trustStoreHolder = new KeyStoreHolder(trustStore, trustStorePassword);
                this.trustStores.add(trustStoreHolder);
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new GenericKeyStoreException(KEY_STORE_LOADING_EXCEPTION, e);
            }
            this.oneWayAuthenticationEnabled = true;
            return this;
        }

        public Builder withTrustStore(KeyStore trustStore, char[] trustStorePassword) {
            this.validateKeyStore(trustStore, trustStorePassword, TRUST_STORE_VALIDATION_EXCEPTION_MESSAGE);
            KeyStoreHolder trustStoreHolder = new KeyStoreHolder(trustStore, trustStorePassword);
            this.trustStores.add(trustStoreHolder);
            this.oneWayAuthenticationEnabled = true;
            return this;
        }

        public Builder withIdentity(String identityPath, char[] identityPassword) {
            return this.withIdentity(identityPath, identityPassword, KeyStore.getDefaultType());
        }

        public Builder withIdentity(String identityPath, char[] identityPassword, String identityType) {
            if (StringUtils.isBlank((CharSequence)identityPath) || ArrayUtils.isEmpty((char[])identityPassword) || StringUtils.isBlank((CharSequence)identityType)) {
                throw new GenericKeyStoreException(IDENTITY_VALIDATION_EXCEPTION_MESSAGE);
            }
            try {
                KeyStore identity = KeystoreUtils.loadKeyStore(identityPath, identityPassword, identityType);
                KeyStoreHolder identityHolder = new KeyStoreHolder(identity, identityPassword);
                this.identities.add(identityHolder);
                this.twoWayAuthenticationEnabled = true;
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new GenericKeyStoreException(KEY_STORE_LOADING_EXCEPTION, e);
            }
            return this;
        }

        public Builder withIdentity(Path identityPath, char[] identityPassword) {
            return this.withIdentity(identityPath, identityPassword, KeyStore.getDefaultType());
        }

        public Builder withIdentity(Path identityPath, char[] identityPassword, String identityType) {
            if (Objects.isNull(identityPath) || ArrayUtils.isEmpty((char[])identityPassword) || StringUtils.isBlank((CharSequence)identityType)) {
                throw new GenericKeyStoreException(IDENTITY_VALIDATION_EXCEPTION_MESSAGE);
            }
            try {
                KeyStore identity = KeystoreUtils.loadKeyStore(identityPath, identityPassword, identityType);
                KeyStoreHolder identityHolder = new KeyStoreHolder(identity, identityPassword);
                this.identities.add(identityHolder);
                this.twoWayAuthenticationEnabled = true;
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new GenericKeyStoreException(KEY_STORE_LOADING_EXCEPTION, e);
            }
            return this;
        }

        public Builder withIdentity(KeyStore identity, char[] identityPassword) {
            this.validateKeyStore(identity, identityPassword, IDENTITY_VALIDATION_EXCEPTION_MESSAGE);
            KeyStoreHolder identityHolder = new KeyStoreHolder(identity, identityPassword);
            this.identities.add(identityHolder);
            this.twoWayAuthenticationEnabled = true;
            return this;
        }

        private void validateKeyStore(KeyStore keyStore, char[] keyStorePassword, String exceptionMessage) {
            if (Objects.isNull(keyStore) || ArrayUtils.isEmpty((char[])keyStorePassword)) {
                throw new GenericKeyStoreException(exceptionMessage);
            }
        }

        public Builder withHostnameVerifierEnabled(boolean hostnameVerifierEnabled) {
            this.hostnameVerifierEnabled = hostnameVerifierEnabled;
            return this;
        }

        public Builder withProtocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder withTrustingAllCertificatesWithoutValidation() {
            this.trustingAllCertificatesWithoutValidationEnabled = true;
            this.oneWayAuthenticationEnabled = true;
            return this;
        }

        public SSLFactory build() {
            SSLFactory sslFactory = new SSLFactory();
            if (!this.oneWayAuthenticationEnabled && !this.twoWayAuthenticationEnabled) {
                return sslFactory;
            }
            this.validateTrustStore();
            this.buildHostnameVerifier(sslFactory);
            sslFactory.protocol = this.protocol;
            sslFactory.securityEnabled = true;
            sslFactory.includeDefaultJdkTrustStore = this.includeDefaultJdkTrustStore;
            sslFactory.trustingAllCertificatesWithoutValidationEnabled = this.trustingAllCertificatesWithoutValidationEnabled;
            if (this.twoWayAuthenticationEnabled) {
                this.oneWayAuthenticationEnabled = false;
            }
            this.buildSLLContextForOneWayAuthenticationIfEnabled(sslFactory);
            this.buildSLLContextForTwoWayAuthenticationIfEnabled(sslFactory);
            return sslFactory;
        }

        private void buildHostnameVerifier(SSLFactory sslFactory) {
            if (this.hostnameVerifierEnabled) {
                sslFactory.hostnameVerifier = (HostnameVerifier)new DefaultHostnameVerifier();
            } else {
                sslFactory.hostnameVerifier = (HostnameVerifier)new NoopHostnameVerifier();
            }
        }

        private void buildSLLContextForOneWayAuthenticationIfEnabled(SSLFactory sslFactory) {
            if (this.oneWayAuthenticationEnabled) {
                sslFactory.oneWayAuthenticationEnabled = true;
                sslFactory.trustStores.addAll(this.trustStores);
                sslFactory.createSSLContextWithTrustStore();
            }
        }

        private void buildSLLContextForTwoWayAuthenticationIfEnabled(SSLFactory sslFactory) {
            if (this.twoWayAuthenticationEnabled) {
                sslFactory.twoWayAuthenticationEnabled = true;
                sslFactory.identities.addAll(this.identities);
                sslFactory.trustStores.addAll(this.trustStores);
                sslFactory.createSSLContextWithKeyStoreAndTrustStore();
            }
        }

        private void validateTrustStore() {
            if (this.trustStores.isEmpty() && !this.includeDefaultJdkTrustStore && !this.trustingAllCertificatesWithoutValidationEnabled) {
                throw new GenericKeyStoreException(TRUST_STRATEGY_VALIDATION_EXCEPTION_MESSAGE);
            }
        }
    }
}

