/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.log.util;

import org.slf4j.Logger;

public final class ValidationUtils {
    private ValidationUtils() {
    }

    public static <T extends Logger, U extends Logger> void requireLoggerOfType(T actualLogger, Class<U> requiredLogger) {
        if (!requiredLogger.isInstance(actualLogger)) {
            String actualLoggerType = actualLogger != null ? actualLogger.getClass().getName() : "nothing";
            throw new IllegalArgumentException(String.format("SLF4J Logger implementation should be of the type [%s] but found [%s].", requiredLogger.getName(), actualLoggerType));
        }
    }
}

