/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl.util;

import java.security.KeyStore;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import nl.altindag.ssl.util.AndroidCertificateUtils;
import nl.altindag.ssl.util.LinuxCertificateUtils;
import nl.altindag.ssl.util.MacCertificateUtils;
import nl.altindag.ssl.util.OSCertificateUtils;
import nl.altindag.ssl.util.WindowsCertificateUtils;
import nl.altindag.sude.Logger;
import nl.altindag.sude.LoggerFactory;

enum OperatingSystem {
    MAC(MacCertificateUtils.getInstance()),
    LINUX(LinuxCertificateUtils.getInstance()),
    ANDROID(AndroidCertificateUtils.getInstance()),
    WINDOWS(WindowsCertificateUtils.getInstance()),
    UNKNOWN(null);

    private static final Logger LOGGER;
    private final OSCertificateUtils osCertificateUtils;

    private OperatingSystem(OSCertificateUtils osCertificateUtils) {
        this.osCertificateUtils = osCertificateUtils;
    }

    static String getResolvedOsName() {
        return System.getProperty("os.name").toLowerCase();
    }

    static OperatingSystem get() {
        String operatingSystem = OperatingSystem.getResolvedOsName();
        if (operatingSystem.contains("windows")) {
            return WINDOWS;
        }
        if (operatingSystem.contains("mac")) {
            return MAC;
        }
        if (operatingSystem.contains("linux")) {
            String javaVendor = System.getProperty("java.vendor", "").toLowerCase();
            String javaVmVendor = System.getProperty("java.vm.vendor", "").toLowerCase();
            String javaRuntimeName = System.getProperty("java.runtime.name", "").toLowerCase();
            if (javaVendor.equals("the android project") || javaVmVendor.equals("the android project") || javaRuntimeName.equals("android runtime")) {
                return ANDROID;
            }
            return LINUX;
        }
        return UNKNOWN;
    }

    List<KeyStore> getTrustStores() {
        return this.getOsCertificateUtils().map(OSCertificateUtils::getTrustStores).orElseGet(() -> {
            String resolvedOsName = OperatingSystem.getResolvedOsName();
            LOGGER.warn(String.format("No system KeyStores available for [%s]", resolvedOsName));
            return Collections.emptyList();
        });
    }

    Optional<OSCertificateUtils> getOsCertificateUtils() {
        return Optional.ofNullable(this.osCertificateUtils);
    }

    static {
        LOGGER = LoggerFactory.getLogger(OperatingSystem.class);
    }
}

