/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.processor.typeBuilders;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLType;
import graphql.annotations.annotationTypes.GraphQLUnion;
import graphql.annotations.processor.ProcessingElementsContainer;
import graphql.annotations.processor.exceptions.GraphQLAnnotationsException;
import graphql.annotations.processor.retrievers.GraphQLObjectInfoRetriever;
import graphql.annotations.processor.typeFunctions.TypeFunction;
import graphql.annotations.processor.util.ReflectionKit;
import graphql.annotations.typeResolvers.UnionTypeResolver;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLUnionType;
import graphql.schema.TypeResolver;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Optional;

public class UnionBuilder {
    private GraphQLObjectInfoRetriever graphQLObjectInfoRetriever;

    public UnionBuilder(GraphQLObjectInfoRetriever graphQLObjectInfoRetriever) {
        this.graphQLObjectInfoRetriever = graphQLObjectInfoRetriever;
    }

    public GraphQLUnionType.Builder getUnionBuilder(Class<?> iface, ProcessingElementsContainer container) throws GraphQLAnnotationsException, IllegalArgumentException {
        if (!iface.isInterface()) {
            throw new IllegalArgumentException(iface + " is not an interface");
        }
        GraphQLUnionType.Builder builder = GraphQLUnionType.newUnionType();
        GraphQLUnion unionAnnotation = iface.getAnnotation(GraphQLUnion.class);
        builder.name(this.graphQLObjectInfoRetriever.getTypeName(iface));
        GraphQLDescription description = iface.getAnnotation(GraphQLDescription.class);
        if (description != null) {
            builder.description(description.value());
        }
        GraphQLType typeAnnotation = iface.getAnnotation(GraphQLType.class);
        TypeFunction typeFunction = container.getDefaultTypeFunction();
        if (typeAnnotation != null) {
            typeFunction = ReflectionKit.newInstance(typeAnnotation.value());
        }
        TypeFunction finalTypeFunction = typeFunction;
        Arrays.stream(unionAnnotation.possibleTypes()).map(aClass -> finalTypeFunction.buildType((Class<?>)aClass, null, container)).map(v -> (GraphQLObjectType)v).forEach(arg_0 -> ((GraphQLUnionType.Builder)builder).possibleType(arg_0));
        TypeResolver typeResolver = this.getTypeResolver(container, unionAnnotation);
        builder.typeResolver(typeResolver);
        return builder;
    }

    private TypeResolver getTypeResolver(ProcessingElementsContainer container, GraphQLUnion unionAnnotation) {
        Optional<Constructor> typeResolverConstructorOptional = Arrays.stream(unionAnnotation.typeResolver().getConstructors()).filter(constructor -> constructor.getParameterCount() == 0 || this.constructorHasPossibleTypesAndContainerAsParameters(container, (Constructor<?>)constructor)).findFirst();
        return typeResolverConstructorOptional.map(constructor -> {
            if (constructor.getParameterCount() == 0) {
                return (TypeResolver)ReflectionKit.constructNewInstance(constructor, new Object[0]);
            }
            return (TypeResolver)ReflectionKit.constructNewInstance(constructor, unionAnnotation.possibleTypes(), container);
        }).orElseGet(() -> new UnionTypeResolver(unionAnnotation.possibleTypes(), container));
    }

    private boolean constructorHasPossibleTypesAndContainerAsParameters(ProcessingElementsContainer container, Constructor<?> constructor) {
        return constructor.getParameterCount() == 2 && Class[].class.isAssignableFrom(constructor.getParameterTypes()[0]) && container.getClass().isAssignableFrom(constructor.getParameterTypes()[1]);
    }
}

