/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.processor;

import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLTypeExtension;
import graphql.annotations.processor.ProcessingElementsContainer;
import graphql.annotations.processor.exceptions.GraphQLAnnotationsException;
import graphql.annotations.processor.graphQLProcessors.GraphQLAnnotationsProcessor;
import graphql.annotations.processor.graphQLProcessors.GraphQLInputProcessor;
import graphql.annotations.processor.graphQLProcessors.GraphQLOutputProcessor;
import graphql.annotations.processor.retrievers.GraphQLObjectHandler;
import graphql.annotations.processor.typeFunctions.DefaultTypeFunction;
import graphql.annotations.processor.typeFunctions.TypeFunction;
import graphql.annotations.processor.util.NamingKit;
import graphql.relay.Relay;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLType;
import java.util.HashSet;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class GraphQLAnnotations
implements GraphQLAnnotationsProcessor {
    private GraphQLObjectHandler graphQLObjectHandler;
    private ProcessingElementsContainer container;
    public static GraphQLAnnotations instance = new GraphQLAnnotations();

    public GraphQLAnnotations() {
        this(new DefaultTypeFunction(new GraphQLInputProcessor(), new GraphQLOutputProcessor()), new GraphQLObjectHandler());
    }

    public GraphQLAnnotations(TypeFunction defaultTypeFunction, GraphQLObjectHandler graphQLObjectHandler) {
        this.graphQLObjectHandler = graphQLObjectHandler;
        this.container = new ProcessingElementsContainer(defaultTypeFunction);
    }

    public static GraphQLAnnotations getInstance() {
        return instance;
    }

    @Override
    public void setRelay(Relay relay) {
        this.container.setRelay(relay);
    }

    public String getTypeName(Class<?> objectClass) {
        GraphQLName name = objectClass.getAnnotation(GraphQLName.class);
        return NamingKit.toGraphqlName(name == null ? objectClass.getSimpleName() : name.value());
    }

    public static GraphQLObjectType object(Class<?> object) throws GraphQLAnnotationsException {
        GraphQLAnnotations instance = GraphQLAnnotations.getInstance();
        return instance.graphQLObjectHandler.getObject(object, instance.getContainer());
    }

    @Override
    public void registerTypeExtension(Class<?> objectClass) {
        GraphQLTypeExtension typeExtension = objectClass.getAnnotation(GraphQLTypeExtension.class);
        if (typeExtension == null) {
            throw new GraphQLAnnotationsException("Class is not annotated with GraphQLTypeExtension", null);
        }
        Class<?> aClass = typeExtension.value();
        if (!this.container.getExtensionsTypeRegistry().containsKey(aClass)) {
            this.container.getExtensionsTypeRegistry().put(aClass, new HashSet());
        }
        this.container.getExtensionsTypeRegistry().get(aClass).add(objectClass);
    }

    @Override
    public void unregisterTypeExtension(Class<?> objectClass) {
        GraphQLTypeExtension typeExtension = objectClass.getAnnotation(GraphQLTypeExtension.class);
        if (typeExtension == null) {
            throw new GraphQLAnnotationsException("Class is not annotated with GraphQLTypeExtension", null);
        }
        Class<?> aClass = typeExtension.value();
        if (this.container.getExtensionsTypeRegistry().containsKey(aClass)) {
            this.container.getExtensionsTypeRegistry().get(aClass).remove(objectClass);
        }
    }

    @Override
    public void registerType(TypeFunction typeFunction) {
        ((DefaultTypeFunction)this.container.getDefaultTypeFunction()).register(typeFunction);
    }

    public static void register(TypeFunction typeFunction) {
        GraphQLAnnotations.getInstance().registerType(typeFunction);
    }

    public Map<String, GraphQLType> getTypeRegistry() {
        return this.container.getTypeRegistry();
    }

    public ProcessingElementsContainer getContainer() {
        return this.container;
    }

    public void setContainer(ProcessingElementsContainer container) {
        this.container = container;
    }

    @Reference(target="(type=default)")
    public void setDefaultTypeFunction(TypeFunction function) {
        this.container.setDefaultTypeFunction(function);
    }
}

