/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.dataFetchers;

import graphql.annotations.annotationTypes.GraphQLBatched;
import graphql.annotations.annotationTypes.GraphQLInvokeDetached;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.processor.ProcessingElementsContainer;
import graphql.annotations.processor.typeFunctions.TypeFunction;
import graphql.annotations.processor.util.NamingKit;
import graphql.annotations.processor.util.PrefixesUtil;
import graphql.annotations.processor.util.ReflectionKit;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class MethodDataFetcher<T>
implements DataFetcher<T> {
    private final Method method;
    private final ProcessingElementsContainer container;
    private final TypeFunction typeFunction;

    public MethodDataFetcher(Method method, TypeFunction typeFunction, ProcessingElementsContainer container) {
        this.method = method;
        this.typeFunction = typeFunction;
        this.container = container;
    }

    public T get(DataFetchingEnvironment environment) {
        try {
            Object obj;
            if (Modifier.isStatic(this.method.getModifiers())) {
                return (T)this.method.invoke(null, this.invocationArgs(environment, this.container));
            }
            if (this.method.isAnnotationPresent(GraphQLBatched.class) || this.method.isAnnotationPresent(GraphQLInvokeDetached.class)) {
                obj = ReflectionKit.newInstance(this.method.getDeclaringClass());
            } else if (!this.method.getDeclaringClass().isInstance(environment.getSource())) {
                obj = ReflectionKit.newInstance(this.method.getDeclaringClass(), environment.getSource());
            } else {
                obj = environment.getSource();
                if (obj == null) {
                    return null;
                }
            }
            if (obj == null && environment.getSource() != null) {
                Object value = this.getGraphQLFieldValue(environment.getSource(), this.method.getName());
                return (T)value;
            }
            return (T)this.method.invoke(obj, this.invocationArgs(environment, this.container));
        }
        catch (IllegalAccessException | NoSuchFieldException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Object[] invocationArgs(DataFetchingEnvironment environment, ProcessingElementsContainer container) {
        ArrayList<Object> result = new ArrayList<Object>();
        Map envArgs = environment.getArguments();
        for (Parameter p : this.method.getParameters()) {
            GraphQLName name = p.getAnnotation(GraphQLName.class);
            String parameterName = name != null ? NamingKit.toGraphqlName(name.value()) : NamingKit.toGraphqlName(p.getName());
            Class<?> paramType = p.getType();
            if (DataFetchingEnvironment.class.isAssignableFrom(paramType)) {
                result.add(environment);
                continue;
            }
            GraphQLType graphQLType = this.typeFunction.buildType(true, paramType, p.getAnnotatedType(), container);
            if (envArgs.containsKey(parameterName)) {
                result.add(this.buildArg(p.getParameterizedType(), graphQLType, envArgs.get(parameterName)));
                continue;
            }
            result.add(null);
        }
        return result.toArray();
    }

    private Object buildArg(Type p, GraphQLType graphQLType, Object arg) {
        if (arg == null) {
            return null;
        }
        if (graphQLType instanceof GraphQLNonNull) {
            graphQLType = ((GraphQLNonNull)graphQLType).getWrappedType();
        }
        if (p instanceof Class && graphQLType instanceof GraphQLInputObjectType) {
            int n = 0;
            Constructor<?>[] constructors = ((Class)p).getConstructors();
            Constructor<?>[] constructorArray = constructors;
            int n2 = constructorArray.length;
            if (n < n2) {
                Constructor<?> constructor = constructorArray[n];
                Parameter[] parameters = constructor.getParameters();
                if (parameters.length == 1 && parameters[0].getType().isAssignableFrom(arg.getClass())) {
                    return ReflectionKit.constructNewInstance(constructor, arg);
                }
                ArrayList<Object> objects = new ArrayList<Object>();
                Map map = (Map)arg;
                for (Parameter parameter : parameters) {
                    String name = NamingKit.toGraphqlName(parameter.getAnnotation(GraphQLName.class) != null ? parameter.getAnnotation(GraphQLName.class).value() : parameter.getName());
                    objects.add(this.buildArg(parameter.getParameterizedType(), (GraphQLType)((GraphQLInputObjectType)graphQLType).getField(name).getType(), map.get(name)));
                }
                return ReflectionKit.constructNewInstance(constructor, objects.toArray(new Object[objects.size()]));
            }
            return null;
        }
        if (p instanceof ParameterizedType && graphQLType instanceof GraphQLList) {
            ArrayList<Object> list = new ArrayList<Object>();
            Type subType = ((ParameterizedType)p).getActualTypeArguments()[0];
            GraphQLType wrappedType = ((GraphQLList)graphQLType).getWrappedType();
            for (Object item : (List)arg) {
                list.add(this.buildArg(subType, wrappedType, item));
            }
            return list;
        }
        return arg;
    }

    private Object getGraphQLFieldValue(Object source, String fieldName) throws IllegalAccessException, NoSuchFieldException, InvocationTargetException {
        Object methodValue = this.getValueFromMethod(source, fieldName);
        if (methodValue != null) {
            return methodValue;
        }
        Object fieldValue = this.getValueFromField(source, fieldName);
        if (fieldValue != null) {
            return fieldValue;
        }
        throw new NoSuchFieldException("No GraphQL field found");
    }

    private Object getValueFromField(Object source, String fieldName) throws IllegalAccessException {
        List<String> namesToSearchFor = Arrays.asList(fieldName, PrefixesUtil.extractPrefixedName(fieldName));
        for (String name : namesToSearchFor) {
            Field field = this.getField(source.getClass(), name);
            if (!this.isFieldContainsValue(field)) continue;
            return field.get(source);
        }
        return null;
    }

    private boolean isFieldContainsValue(Field field) throws IllegalAccessException {
        if (field != null) {
            field.setAccessible(true);
            return true;
        }
        return false;
    }

    private Field getField(Class<?> clazz, String name) {
        Field field = null;
        while (clazz != null && field == null) {
            try {
                field = clazz.getDeclaredField(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            clazz = clazz.getSuperclass();
        }
        return field;
    }

    private Object getValueFromMethod(Object source, String fieldName) throws IllegalAccessException, InvocationTargetException {
        String[] orderedPrefixes;
        for (String orderedPrefix : orderedPrefixes = new String[]{"", "get", "is"}) {
            Method method = this.getMethod(source.getClass(), fieldName, orderedPrefix);
            if (method == null) continue;
            return method.invoke(source, new Object[0]);
        }
        return null;
    }

    private Method getMethod(Class<?> clazz, String name, String prefix) {
        String prefixedName = prefix.isEmpty() ? name : PrefixesUtil.addPrefixToPropertyName(prefix, name);
        Method method = null;
        while (clazz != null && method == null) {
            try {
                method = clazz.getDeclaredMethod(prefixedName, new Class[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            clazz = clazz.getSuperclass();
        }
        return method;
    }
}

