/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.processor.typeBuilders;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLTypeResolver;
import graphql.annotations.processor.ProcessingElementsContainer;
import graphql.annotations.processor.exceptions.GraphQLAnnotationsException;
import graphql.annotations.processor.retrievers.GraphQLFieldRetriever;
import graphql.annotations.processor.retrievers.GraphQLInterfaceRetriever;
import graphql.annotations.processor.retrievers.GraphQLObjectInfoRetriever;
import graphql.annotations.processor.searchAlgorithms.BreadthFirstSearch;
import graphql.annotations.processor.searchAlgorithms.ParentalSearch;
import graphql.annotations.processor.util.ObjectUtil;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLTypeReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ObjectBuilder {
    private GraphQLObjectInfoRetriever graphQLObjectInfoRetriever;
    private BreadthFirstSearch breadthFirstSearch;
    private ParentalSearch parentalSearch;
    private GraphQLFieldRetriever graphQLFieldRetriever;
    private GraphQLInterfaceRetriever graphQLInterfaceRetriever;

    public ObjectBuilder(GraphQLObjectInfoRetriever graphQLObjectInfoRetriever, ParentalSearch parentalSearch, BreadthFirstSearch breadthFirstSearch, GraphQLFieldRetriever graphQLFieldRetriever, GraphQLInterfaceRetriever graphQLInterfaceRetriever) {
        this.graphQLObjectInfoRetriever = graphQLObjectInfoRetriever;
        this.breadthFirstSearch = breadthFirstSearch;
        this.parentalSearch = parentalSearch;
        this.graphQLFieldRetriever = graphQLFieldRetriever;
        this.graphQLInterfaceRetriever = graphQLInterfaceRetriever;
    }

    public GraphQLObjectType.Builder getObjectBuilder(Class<?> object, ProcessingElementsContainer container) throws GraphQLAnnotationsException {
        GraphQLFieldDefinition gqlField;
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject();
        builder.name(this.graphQLObjectInfoRetriever.getTypeName(object));
        GraphQLDescription description = object.getAnnotation(GraphQLDescription.class);
        if (description != null) {
            builder.description(description.value());
        }
        ArrayList<String> fieldsDefined = new ArrayList<String>();
        for (Method method : this.graphQLObjectInfoRetriever.getOrderedMethods(object)) {
            if (method.isBridge() || method.isSynthetic() || !this.breadthFirstSearch.isFound(method)) continue;
            gqlField = this.graphQLFieldRetriever.getField(method, container);
            fieldsDefined.add(gqlField.getName());
            builder.field(gqlField);
        }
        for (Field field : ObjectUtil.getAllFields(object).values()) {
            if (Modifier.isStatic(field.getModifiers()) || !this.parentalSearch.isFound(field)) continue;
            gqlField = this.graphQLFieldRetriever.getField(field, container);
            fieldsDefined.add(gqlField.getName());
            builder.field(gqlField);
        }
        for (Iterator<AccessibleObject> iterator : object.getInterfaces()) {
            if (((Class)((Object)iterator)).getAnnotation(GraphQLTypeResolver.class) == null) continue;
            String ifaceName = this.graphQLObjectInfoRetriever.getTypeName((Class<?>)((Object)iterator));
            if (container.getProcessing().contains(ifaceName)) {
                builder.withInterface(new GraphQLTypeReference(ifaceName));
            } else {
                builder.withInterface((GraphQLInterfaceType)this.graphQLInterfaceRetriever.getInterface((Class<?>)((Object)iterator), container));
            }
            builder.fields(this.graphQLFieldRetriever.getExtensionFields((Class<?>)((Object)iterator), (List<String>)fieldsDefined, container));
        }
        builder.fields(this.graphQLFieldRetriever.getExtensionFields(object, fieldsDefined, container));
        return builder;
    }
}

