/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations;

import graphql.annotations.Connection;
import graphql.annotations.DefaultTypeFunction;
import graphql.annotations.GraphQLConnection;
import graphql.annotations.GraphQLDataFetcher;
import graphql.annotations.GraphQLDefaultValue;
import graphql.annotations.GraphQLDeprecate;
import graphql.annotations.GraphQLDescription;
import graphql.annotations.GraphQLField;
import graphql.annotations.GraphQLName;
import graphql.annotations.GraphQLRelayMutation;
import graphql.annotations.GraphQLType;
import graphql.annotations.GraphQLTypeResolver;
import graphql.annotations.MethodDataFetcher;
import graphql.annotations.RelayMutationMethodDataFetcher;
import graphql.annotations.TypeFunction;
import graphql.relay.Relay;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.FieldDataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;

public class GraphQLAnnotations {
    public static GraphQLInterfaceType iface(Class<?> iface) throws IllegalAccessException, InstantiationException {
        GraphQLInterfaceType.Builder builder = GraphQLAnnotations.ifaceBuilder(iface);
        return builder.build();
    }

    public static GraphQLInterfaceType.Builder ifaceBuilder(Class<?> iface) throws InstantiationException, IllegalAccessException {
        if (!iface.isInterface()) {
            throw new IllegalArgumentException(iface + " is not an interface");
        }
        GraphQLInterfaceType.Builder builder = GraphQLInterfaceType.newInterface();
        GraphQLName name = iface.getAnnotation(GraphQLName.class);
        builder.name(name == null ? iface.getSimpleName() : name.value());
        GraphQLDescription description = iface.getAnnotation(GraphQLDescription.class);
        if (description != null) {
            builder.description(description.value());
        }
        for (Method method : iface.getMethods()) {
            boolean valid;
            boolean bl = valid = !Modifier.isStatic(method.getModifiers()) && method.getAnnotation(GraphQLField.class) != null;
            if (!valid) continue;
            builder.field(GraphQLAnnotations.field(method));
        }
        GraphQLTypeResolver typeResolver = iface.getAnnotation(GraphQLTypeResolver.class);
        if (typeResolver == null) {
            throw new IllegalArgumentException(iface + " should have @GraphQLTypeResolver annotation defined");
        }
        builder.typeResolver(typeResolver.value().newInstance());
        return builder;
    }

    private static Class<?> getDeclaringClass(Method method) {
        Class<?> object;
        Class<?> declaringClass = object = method.getDeclaringClass();
        for (Class<?> iface : object.getInterfaces()) {
            try {
                iface.getMethod(method.getName(), method.getParameterTypes());
                declaringClass = iface;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        try {
            if (object.getSuperclass() != null) {
                object.getSuperclass().getMethod(method.getName(), method.getParameterTypes());
                declaringClass = object.getSuperclass();
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return declaringClass;
    }

    public static GraphQLObjectType object(Class<?> object) throws IllegalAccessException, InstantiationException, NoSuchMethodException {
        GraphQLObjectType.Builder builder = GraphQLAnnotations.objectBuilder(object);
        return builder.build();
    }

    public static GraphQLObjectType.Builder objectBuilder(Class<?> object) throws NoSuchMethodException, InstantiationException, IllegalAccessException {
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject();
        GraphQLName name = object.getAnnotation(GraphQLName.class);
        builder.name(name == null ? object.getSimpleName() : name.value());
        GraphQLDescription description = object.getAnnotation(GraphQLDescription.class);
        if (description != null) {
            builder.description(description.value());
        }
        for (Method method : object.getMethods()) {
            boolean valid;
            Class<?> declaringClass = GraphQLAnnotations.getDeclaringClass(method);
            boolean bl = valid = !Modifier.isStatic(method.getModifiers()) && (method.getAnnotation(GraphQLField.class) != null || declaringClass.getMethod(method.getName(), method.getParameterTypes()).getAnnotation(GraphQLField.class) != null);
            if (!valid) continue;
            builder.field(GraphQLAnnotations.field(method));
        }
        for (AccessibleObject accessibleObject : object.getFields()) {
            boolean valid;
            boolean bl = valid = !Modifier.isStatic(((Field)accessibleObject).getModifiers()) && ((Field)accessibleObject).getAnnotation(GraphQLField.class) != null;
            if (!valid) continue;
            builder.field(GraphQLAnnotations.field((Field)accessibleObject));
        }
        for (AnnotatedElement annotatedElement : object.getInterfaces()) {
            if (((Class)annotatedElement).getAnnotation(GraphQLTypeResolver.class) == null) continue;
            builder.withInterface(GraphQLAnnotations.iface(annotatedElement));
        }
        return builder;
    }

    protected static GraphQLFieldDefinition field(Field field) throws IllegalAccessException, InstantiationException {
        GraphQLDataFetcher dataFetcher;
        Object actualDataFetcher;
        GraphQLDeprecate deprecate;
        GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition();
        GraphQLName name = field.getAnnotation(GraphQLName.class);
        builder.name(name == null ? field.getName() : name.value());
        GraphQLType annotation = field.getAnnotation(GraphQLType.class);
        if (annotation == null) {
            annotation = new defaultGraphQLType();
        }
        TypeFunction typeFunction = annotation.value().newInstance();
        GraphQLOutputType type = (GraphQLOutputType)typeFunction.apply(field.getType(), field.getAnnotatedType());
        GraphQLOutputType outputType = field.getAnnotation(NotNull.class) == null ? type : new GraphQLNonNull((graphql.schema.GraphQLType)type);
        boolean isConnection = GraphQLAnnotations.isConnection(field, field.getType(), type);
        outputType = GraphQLAnnotations.getGraphQLConnection(isConnection, field, type, outputType, builder);
        builder.type(outputType);
        GraphQLDescription description = field.getAnnotation(GraphQLDescription.class);
        if (description != null) {
            builder.description(description.value());
        }
        if ((deprecate = field.getAnnotation(GraphQLDeprecate.class)) != null) {
            builder.deprecate(deprecate.value());
        }
        if (field.getAnnotation(Deprecated.class) != null) {
            builder.deprecate("Deprecated");
        }
        Object object = actualDataFetcher = (dataFetcher = field.getAnnotation(GraphQLDataFetcher.class)) == null ? new FieldDataFetcher(field.getName()) : dataFetcher.value().newInstance();
        if (isConnection) {
            actualDataFetcher = new ConnectionDataFetcher(field.getAnnotation(GraphQLConnection.class).connection(), (DataFetcher)actualDataFetcher);
        }
        builder.dataFetcher((DataFetcher)actualDataFetcher);
        return builder.build();
    }

    private static GraphQLOutputType getGraphQLConnection(boolean isConnection, AccessibleObject field, GraphQLOutputType type, GraphQLOutputType outputType, GraphQLFieldDefinition.Builder builder) {
        if (isConnection && type instanceof GraphQLList) {
            graphql.schema.GraphQLType wrappedType = ((GraphQLList)type).getWrappedType();
            assert (wrappedType instanceof GraphQLObjectType);
            String annValue = field.getAnnotation(GraphQLConnection.class).name();
            String connectionName = annValue.isEmpty() ? wrappedType.getName() : annValue;
            Relay relay = new Relay();
            GraphQLObjectType edgeType = relay.edgeType(connectionName, (GraphQLOutputType)wrappedType, null, Collections.emptyList());
            outputType = relay.connectionType(connectionName, edgeType, Collections.emptyList());
            builder.argument(relay.getConnectionFieldArguments());
        }
        return outputType;
    }

    private static boolean isConnection(AccessibleObject obj, Class<?> klass, GraphQLOutputType type) {
        return obj.isAnnotationPresent(GraphQLConnection.class) && type instanceof GraphQLList && ((GraphQLList)type).getWrappedType() instanceof GraphQLObjectType;
    }

    protected static GraphQLFieldDefinition field(Method method) throws InstantiationException, IllegalAccessException {
        GraphQLDataFetcher dataFetcher;
        Object actualDataFetcher;
        GraphQLDeprecate deprecate;
        GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition();
        String name = method.getName().replaceFirst("^(is|get|set)(.+)", "$2");
        name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        GraphQLName nameAnn = method.getAnnotation(GraphQLName.class);
        builder.name(nameAnn == null ? name : nameAnn.value());
        GraphQLType annotation = method.getAnnotation(GraphQLType.class);
        if (annotation == null) {
            annotation = new defaultGraphQLType();
        }
        final TypeFunction typeFunction = annotation.value().newInstance();
        final AnnotatedType annotatedReturnType = method.getAnnotatedReturnType();
        GraphQLOutputType type = (GraphQLOutputType)typeFunction.apply(method.getReturnType(), annotatedReturnType);
        GraphQLOutputType outputType = method.getAnnotation(NotNull.class) == null ? type : new GraphQLNonNull((graphql.schema.GraphQLType)type);
        boolean isConnection = GraphQLAnnotations.isConnection(method, method.getReturnType(), type);
        outputType = GraphQLAnnotations.getGraphQLConnection(isConnection, method, type, outputType, builder);
        builder.type(outputType);
        List<GraphQLArgument> args = Arrays.asList(method.getParameters()).stream().filter(p -> !DataFetchingEnvironment.class.isAssignableFrom(p.getType())).map(new Function<Parameter, GraphQLArgument>(){

            @Override
            public GraphQLArgument apply(Parameter parameter) {
                Class<?> t = parameter.getType();
                graphql.schema.GraphQLType graphQLType = (graphql.schema.GraphQLType)typeFunction.apply(t, annotatedReturnType);
                if (graphQLType instanceof GraphQLObjectType) {
                    GraphQLInputObjectType inputObject = GraphQLAnnotations.inputObject((GraphQLObjectType)graphQLType);
                    graphQLType = inputObject;
                }
                return GraphQLAnnotations.argument(parameter, graphQLType);
            }
        }).collect(Collectors.toList());
        GraphQLFieldDefinition relay = null;
        if (method.isAnnotationPresent(GraphQLRelayMutation.class)) {
            if (!(outputType instanceof GraphQLObjectType) && !(outputType instanceof GraphQLInterfaceType)) {
                throw new RuntimeException("outputType should be an object or an interface");
            }
            StringBuffer titleBuffer = new StringBuffer(method.getName());
            titleBuffer.setCharAt(0, Character.toUpperCase(titleBuffer.charAt(0)));
            String title = titleBuffer.toString();
            List fieldDefinitions = outputType instanceof GraphQLObjectType ? ((GraphQLObjectType)outputType).getFieldDefinitions() : ((GraphQLInterfaceType)outputType).getFieldDefinitions();
            relay = new Relay().mutationWithClientMutationId(title, method.getName(), args.stream().map(t -> GraphQLInputObjectField.newInputObjectField().name(t.getName()).type(t.getType()).description(t.getDescription()).build()).collect(Collectors.toList()), fieldDefinitions, null);
            builder.argument(relay.getArguments());
            builder.type(relay.getType());
        } else {
            builder.argument(args);
        }
        GraphQLDescription description = method.getAnnotation(GraphQLDescription.class);
        if (description != null) {
            builder.description(description.value());
        }
        if ((deprecate = method.getAnnotation(GraphQLDeprecate.class)) != null) {
            builder.deprecate(deprecate.value());
        }
        if (method.getAnnotation(Deprecated.class) != null) {
            builder.deprecate("Deprecated");
        }
        MethodDataFetcher methodDataFetcher = actualDataFetcher = (dataFetcher = method.getAnnotation(GraphQLDataFetcher.class)) == null ? new MethodDataFetcher(method) : dataFetcher.value().newInstance();
        if (method.isAnnotationPresent(GraphQLRelayMutation.class) && relay != null) {
            actualDataFetcher = new RelayMutationMethodDataFetcher(method, args, relay.getArgument("input").getType(), relay.getType());
        }
        if (isConnection) {
            actualDataFetcher = new ConnectionDataFetcher(method.getAnnotation(GraphQLConnection.class).connection(), (DataFetcher)actualDataFetcher);
        }
        builder.dataFetcher((DataFetcher)actualDataFetcher);
        return builder.build();
    }

    public static GraphQLInputObjectType inputObject(GraphQLObjectType graphQLType) {
        GraphQLObjectType object = graphQLType;
        return new GraphQLInputObjectType(object.getName(), object.getDescription(), object.getFieldDefinitions().stream().map(field -> {
            GraphQLOutputType type = field.getType();
            Object inputType = type instanceof GraphQLObjectType ? GraphQLAnnotations.inputObject((GraphQLObjectType)type) : (GraphQLInputType)type;
            return new GraphQLInputObjectField(field.getName(), field.getDescription(), inputType, null);
        }).collect(Collectors.toList()));
    }

    protected static GraphQLArgument argument(Parameter parameter, graphql.schema.GraphQLType t) throws IllegalAccessException, InstantiationException {
        GraphQLName name;
        GraphQLDefaultValue defaultValue;
        GraphQLArgument.Builder builder = GraphQLArgument.newArgument();
        builder.name(parameter.getName());
        builder.type((GraphQLInputType)(parameter.getAnnotation(NotNull.class) == null ? (GraphQLInputType)t : new GraphQLNonNull(t)));
        GraphQLDescription description = parameter.getAnnotation(GraphQLDescription.class);
        if (description != null) {
            builder.description(description.value());
        }
        if ((defaultValue = parameter.getAnnotation(GraphQLDefaultValue.class)) != null) {
            builder.defaultValue(defaultValue.value().newInstance().get());
        }
        if ((name = parameter.getAnnotation(GraphQLName.class)) != null) {
            builder.name(name.value());
        }
        return builder.build();
    }

    private static class ConnectionDataFetcher
    implements DataFetcher {
        private final Class<? extends Connection> connection;
        private final DataFetcher actualDataFetcher;
        private final Constructor<Connection> constructor;

        public ConnectionDataFetcher(Class<? extends Connection> connection, DataFetcher actualDataFetcher) {
            this.connection = connection;
            Optional<Constructor> constructor = Arrays.asList(connection.getConstructors()).stream().filter(c -> c.getParameterCount() == 1).map(c -> c).findFirst();
            if (!constructor.isPresent()) {
                throw new IllegalArgumentException(connection + " doesn't have a single argument constructor");
            }
            this.constructor = constructor.get();
            this.actualDataFetcher = actualDataFetcher;
        }

        public Object get(DataFetchingEnvironment environment) {
            DataFetchingEnvironment env = new DataFetchingEnvironment(environment.getSource(), new HashMap(), environment.getContext(), environment.getFields(), environment.getFieldType(), environment.getParentType(), environment.getGraphQLSchema());
            Connection conn = this.constructor.newInstance(this.actualDataFetcher.get(env));
            return conn.get(environment);
        }
    }

    private static class defaultGraphQLType
    implements GraphQLType {
        private defaultGraphQLType() {
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return GraphQLType.class;
        }

        @Override
        public Class<? extends TypeFunction> value() {
            return DefaultTypeFunction.class;
        }
    }
}

