/*
 * Decompiled with CFR 0.152.
 */
package com.gongbo.export.core;

import com.gongbo.export.annotations.AutoExport;
import com.gongbo.export.annotations.AutoExports;
import com.gongbo.export.config.ExportConfig;
import com.gongbo.export.config.ResultHandler;
import com.gongbo.export.core.ExportHandlers;
import com.gongbo.export.core.handler.FieldFilter;
import com.gongbo.export.core.provider.ExportProvider;
import com.gongbo.export.core.provider.easyexcel.EasyExcelProvider;
import com.gongbo.export.entity.ExportContext;
import com.gongbo.export.entity.ExportFieldInfo;
import com.gongbo.export.entity.ExportParam;
import com.gongbo.export.exception.ExportFailedException;
import com.gongbo.export.exception.NotSupportExportException;
import com.gongbo.export.utils.CollectionUtil;
import com.gongbo.export.utils.ExportUtils;
import com.gongbo.export.utils.ReflectUtil;
import com.gongbo.export.utils.StringUtil;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;

public class ExportHelper {
    public static ExportContext buildExportContext(ExportParam exportParam, Method targetMethod, ExportConfig exportConfig, ResultHandler resultHandler) {
        AutoExport autoExport = ExportHelper.findAutoExportAnnotation(exportParam.getExportTag(), targetMethod);
        Class<?> modelClass = ExportHelper.getModelClass(targetMethod, autoExport, exportConfig);
        List<ExportFieldInfo> exportFieldInfos = ExportHelper.getExportFieldInfos(autoExport, modelClass, EasyExcelProvider.getInstance());
        String fileName = ExportHelper.buildFileName(autoExport);
        return ExportContext.builder().exportConfig(exportConfig).resultHandler(resultHandler).modelClass(modelClass).autoExport(autoExport).fileName(fileName).sheetName(autoExport.sheetName()).template(autoExport.template()).excelType(autoExport.excelType()).fieldInfos(exportFieldInfos).exportParam(exportParam).outputPath(autoExport.outputPath()).formula(autoExport.formula()).userContext(new HashMap<Object, Object>()).build();
    }

    private static Class<?> getModelClass(Method targetMethod, AutoExport autoExport, ExportConfig exportConfig) {
        if (autoExport.modelClass() == AutoExport.NoneModel.class) {
            return null;
        }
        if (autoExport.modelClass() != Object.class) {
            return autoExport.modelClass();
        }
        return Optional.ofNullable(ExportUtils.getModelClass(targetMethod, exportConfig)).orElseThrow(() -> new IllegalArgumentException("\u65e0\u6cd5\u63d0\u53d6\u5230\u5bfc\u51fa\u6a21\u578b\u53c2\u6570\uff0c\u8bf7\u68c0\u67e5\u5bfc\u51fa\u65b9\u6cd5\u6216\u5728EnableExport\u6ce8\u89e3\u4e0a\u6dfb\u52a0modelClass\u5c5e\u6027\uff01"));
    }

    private static List<ExportFieldInfo> getExportFieldInfos(AutoExport autoExport, Class<?> clazz, ExportProvider exportProvider) {
        if (clazz == null) {
            return Collections.emptyList();
        }
        FieldFilter fieldFilter = ExportHandlers.of(autoExport.fieldFilter());
        return ReflectUtil.getFields(clazz, true).stream().map(field -> {
            ExportFieldInfo exportFieldInfo = exportProvider.findExportFieldInfo((Field)field);
            return Optional.ofNullable(exportFieldInfo).filter(exportFieldInfo1 -> fieldFilter.predict((Field)field)).orElse(null);
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static AutoExport findAutoExportAnnotation(String exportTag, Method targetMethod) {
        AutoExport[] autoExports = Optional.ofNullable(targetMethod.getAnnotation(AutoExports.class)).map(AutoExports::value).orElseGet(() -> (AutoExport[])targetMethod.getAnnotationsByType(AutoExport.class));
        if (autoExports == null || autoExports.length == 0) {
            throw new NotSupportExportException(MessageFormat.format("\u8be5\u65b9\u6cd5[{0}]\u4e0d\u652f\u6301\u5bfc\u51fa\uff0c\u82e5\u8981\u5f00\u542f\u5bfc\u51fa\uff0c\u8bf7\u5728\u5bf9\u5e94\u8bf7\u6c42\u65b9\u6cd5\u4e0a\u914d\u7f6eEnableExport\u6ce8\u89e3\u5f00\u542f\u5bfc\u51fa", targetMethod.getName()));
        }
        Predicate<AutoExport> filter = StringUtil.isNotEmpty(exportTag) ? e -> exportTag.equals(e.tag()) : e -> StringUtil.isEmpty(e.tag());
        List autoExportList = Arrays.stream(autoExports).filter(filter).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(autoExportList)) {
            throw new NotSupportExportException(MessageFormat.format("\u5728\u8be5\u65b9\u6cd5[{0}]\u4e0a\u6ca1\u6709\u5339\u914d\u5230\u5bf9\u5e94\u5bfc\u51fa\u5206\u7ec4:{1}", targetMethod.getName(), exportTag));
        }
        if (autoExportList.size() > 1) {
            throw new ExportFailedException(MessageFormat.format("\u5728\u8be5\u65b9\u6cd5[{0}]\u4e0a\u5339\u914d\u5230\u591a\u4e2a\u5bfc\u51fa\u5206\u7ec4\u90fd\u4e3a:{1}", targetMethod.getName(), exportTag));
        }
        return (AutoExport)autoExportList.get(0);
    }

    public static String buildFileName(AutoExport autoExport) {
        String name = ExportHandlers.of(autoExport.fileNameConvert()).apply(autoExport.fileName());
        if (StringUtil.isEmpty(name)) {
            name = String.valueOf(System.currentTimeMillis());
        }
        return name;
    }

    public static void setDownloadResponseHeaders(HttpServletResponse serverHttpResponse, ExportContext exportContext) {
        String fileName = exportContext.getFileName();
        String excelFileSuffix = exportContext.getExcelType().getValue();
        ExportHelper.setDownloadResponseHeaders(serverHttpResponse, fileName + excelFileSuffix);
    }

    public static void setDownloadResponseHeaders(HttpServletResponse serverHttpResponse, String fileName) {
        serverHttpResponse.addHeader("Content-Type", "application/vnd.ms-excel;charset=UTF-8");
        try {
            fileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8.name()).replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        serverHttpResponse.addHeader("Content-Disposition", "attachment;filename*=utf-8''" + fileName);
    }

    private ExportHelper() {
    }
}

