/*
 * Decompiled with CFR 0.152.
 */
package com.gongbo.export.utils;

import com.gongbo.export.config.ExportConfig;
import com.gongbo.export.core.ExportHelper;
import com.gongbo.export.entity.ExportContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletResponse;

public class ExportUtils {
    public static Class<?> getModelClass(Method method, ExportConfig exportConfig) {
        Class<?> returnType = method.getReturnType();
        if (returnType.getName().equals(exportConfig.getResponseClassName())) {
            Type genericReturnType = method.getGenericReturnType();
            if (!(genericReturnType instanceof ParameterizedType)) {
                return null;
            }
            ParameterizedType parameterizedReturnType = (ParameterizedType)genericReturnType;
            Type[] actualTypeArguments = parameterizedReturnType.getActualTypeArguments();
            Type actualTypeArgument = actualTypeArguments[0];
            if (actualTypeArgument instanceof ParameterizedType) {
                Class rawType;
                ParameterizedType parameterizedType = (ParameterizedType)actualTypeArgument;
                if (parameterizedType.getRawType() instanceof Class && Iterable.class.isAssignableFrom(rawType = (Class)parameterizedType.getRawType())) {
                    Type actualType2 = parameterizedType.getActualTypeArguments()[0];
                    if (actualType2 instanceof Class) {
                        return (Class)actualType2;
                    }
                    if (actualType2 instanceof WildcardType) {
                        return null;
                    }
                }
            } else if (actualTypeArgument instanceof Class && ((Class)actualTypeArgument).isArray()) {
                return ((Class)actualTypeArgument).getComponentType();
            }
        }
        return null;
    }

    public static List<?> objectToList(Object result) {
        if (result == null) {
            return Collections.emptyList();
        }
        if (result instanceof Collection) {
            if (result instanceof List) {
                return (List)result;
            }
            return new ArrayList((Collection)result);
        }
        if (result.getClass().isArray()) {
            return Arrays.asList((Object[])result);
        }
        throw new IllegalArgumentException();
    }

    public static OutputStream getExportOutputStream(ExportContext exportContext, HttpServletResponse response) throws IOException {
        if (exportContext.isOutputFile()) {
            Files.createDirectories(Paths.get(exportContext.getOutputPath(), new String[0]), new FileAttribute[0]);
            File file = new File(exportContext.getOutputPath(), exportContext.getFileName() + exportContext.getExcelType().getValue());
            return new FileOutputStream(file);
        }
        ExportHelper.setDownloadResponseHeaders(response, exportContext);
        return response.getOutputStream();
    }

    private ExportUtils() {
    }
}

