/*
 * Decompiled with CFR 0.152.
 */
package com.gongbo.export.entity;

import com.gongbo.export.entity.ExportContext;
import com.gongbo.export.entity.ExportFieldInfo;
import java.util.List;

public class ExportInfo {
    private String fileName;
    private List<ExportFieldInfo> fieldInfos;

    public static ExportInfo buildExportInfo(ExportContext exportContext) {
        return ExportInfo.builder().fileName(exportContext.getFileName()).fieldInfos(exportContext.getFieldInfos()).build();
    }

    public static ExportInfoBuilder builder() {
        return new ExportInfoBuilder();
    }

    public String getFileName() {
        return this.fileName;
    }

    public List<ExportFieldInfo> getFieldInfos() {
        return this.fieldInfos;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setFieldInfos(List<ExportFieldInfo> fieldInfos) {
        this.fieldInfos = fieldInfos;
    }

    public ExportInfo() {
    }

    public ExportInfo(String fileName, List<ExportFieldInfo> fieldInfos) {
        this.fileName = fileName;
        this.fieldInfos = fieldInfos;
    }

    public static class ExportInfoBuilder {
        private String fileName;
        private List<ExportFieldInfo> fieldInfos;

        ExportInfoBuilder() {
        }

        public ExportInfoBuilder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public ExportInfoBuilder fieldInfos(List<ExportFieldInfo> fieldInfos) {
            this.fieldInfos = fieldInfos;
            return this;
        }

        public ExportInfo build() {
            return new ExportInfo(this.fileName, this.fieldInfos);
        }

        public String toString() {
            return "ExportInfo.ExportInfoBuilder(fileName=" + this.fileName + ", fieldInfos=" + this.fieldInfos + ")";
        }
    }
}

