/*
 * Decompiled with CFR 0.152.
 */
package io.github.goldfish07.reschiper.plugin.utils;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class FileUtils {
    private static final String UNIX_LINE_SEPARATOR = "\n";

    @NotNull
    public static String loadFileWithUnixLineSeparators(@NotNull File file) throws IOException {
        Preconditions.checkNotNull((Object)file, (Object)"File must not be null");
        Preconditions.checkArgument((boolean)file.exists(), (Object)"File does not exist");
        Preconditions.checkArgument((boolean)file.isFile(), (Object)"File is not a regular file");
        try (BufferedReader reader = new BufferedReader(new FileReader(file, StandardCharsets.UTF_8));){
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            String string = String.join((CharSequence)UNIX_LINE_SEPARATOR, lines);
            return string;
        }
    }

    public static void writeToFile(@NotNull File file, @NotNull String content) throws IOException {
        Preconditions.checkNotNull((Object)file, (Object)"File must not be null");
        Preconditions.checkNotNull((Object)content, (Object)"Content must not be null");
        try (FileWriter writer = new FileWriter(file, StandardCharsets.UTF_8);){
            writer.write(content);
        }
    }
}

